/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import io.trino.operator.annotations.CastImplementationDependency;
import io.trino.operator.annotations.FunctionImplementationDependency;
import io.trino.operator.annotations.ImplementationDependency;
import io.trino.operator.annotations.LiteralImplementationDependency;
import io.trino.operator.annotations.OperatorImplementationDependency;
import io.trino.operator.annotations.TypeImplementationDependency;
import io.trino.spi.type.NamedTypeSignature;
import io.trino.spi.type.ParameterKind;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TypeSignatureMapping {
    private final Map<String, String> mapping;

    public TypeSignatureMapping(Map<String, String> mapping) {
        this.mapping = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).putAll(mapping).build();
    }

    public Set<String> getTypeParameters() {
        return ImmutableSet.copyOf(this.mapping.keySet());
    }

    public ImplementationDependency mapTypes(ImplementationDependency dependency) {
        if (this.mapping.isEmpty()) {
            return dependency;
        }
        if (dependency instanceof TypeImplementationDependency) {
            TypeImplementationDependency typeDependency = (TypeImplementationDependency)dependency;
            return new TypeImplementationDependency(this.mapTypeSignature(typeDependency.getSignature()));
        }
        if (dependency instanceof LiteralImplementationDependency) {
            return dependency;
        }
        if (dependency instanceof FunctionImplementationDependency) {
            FunctionImplementationDependency functionDependency = (FunctionImplementationDependency)dependency;
            return new FunctionImplementationDependency(functionDependency.getFullyQualifiedName(), (List)functionDependency.getArgumentTypes().stream().map(this::mapTypeSignature).collect(ImmutableList.toImmutableList()), functionDependency.getInvocationConvention(), functionDependency.getType());
        }
        if (dependency instanceof OperatorImplementationDependency) {
            OperatorImplementationDependency operatorDependency = (OperatorImplementationDependency)dependency;
            return new OperatorImplementationDependency(operatorDependency.getOperator(), (List)operatorDependency.getArgumentTypes().stream().map(this::mapTypeSignature).collect(ImmutableList.toImmutableList()), operatorDependency.getInvocationConvention(), operatorDependency.getType());
        }
        if (dependency instanceof CastImplementationDependency) {
            CastImplementationDependency castDependency = (CastImplementationDependency)dependency;
            return new CastImplementationDependency(this.mapTypeSignature(castDependency.getFromType()), this.mapTypeSignature(castDependency.getToType()), castDependency.getInvocationConvention(), castDependency.getType());
        }
        throw new IllegalArgumentException("Unsupported dependency " + dependency);
    }

    public TypeSignature mapTypeSignature(TypeSignature typeSignature) {
        if (this.mapping.isEmpty()) {
            return typeSignature;
        }
        if (this.mapping.containsKey(typeSignature.getBase())) {
            Preconditions.checkArgument((boolean)typeSignature.getParameters().isEmpty(), (String)"Type variable can not have type parameters: %s", (Object)typeSignature);
            return new TypeSignature(this.mapping.get(typeSignature.getBase()), new TypeSignatureParameter[0]);
        }
        return new TypeSignature(typeSignature.getBase(), (List)typeSignature.getParameters().stream().map(this::mapTypeSignatureParameter).collect(ImmutableList.toImmutableList()));
    }

    private TypeSignatureParameter mapTypeSignatureParameter(TypeSignatureParameter parameter) {
        if (parameter.getKind() == ParameterKind.TYPE) {
            return TypeSignatureParameter.typeParameter((TypeSignature)this.mapTypeSignature(parameter.getTypeSignature()));
        }
        if (parameter.getKind() == ParameterKind.NAMED_TYPE) {
            NamedTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
            return TypeSignatureParameter.namedTypeParameter((NamedTypeSignature)new NamedTypeSignature(namedTypeSignature.getFieldName(), this.mapTypeSignature(namedTypeSignature.getTypeSignature())));
        }
        return parameter;
    }
}

