/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.trino.operator.aggregation.AggregationMask;
import io.trino.operator.aggregation.AggregationMaskBuilder;
import io.trino.operator.aggregation.GroupedAccumulator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.AggregationNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class GroupedAggregator {
    private final GroupedAccumulator accumulator;
    private AggregationNode.Step step;
    private final Type intermediateType;
    private final Type finalType;
    private final int[] inputChannels;
    private final OptionalInt maskChannel;
    private final AggregationMaskBuilder maskBuilder;

    public GroupedAggregator(GroupedAccumulator accumulator, AggregationNode.Step step, Type intermediateType, Type finalType, List<Integer> inputChannels, OptionalInt maskChannel, AggregationMaskBuilder maskBuilder) {
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
        this.step = Objects.requireNonNull(step, "step is null");
        this.intermediateType = Objects.requireNonNull(intermediateType, "intermediateType is null");
        this.finalType = Objects.requireNonNull(finalType, "finalType is null");
        this.inputChannels = Ints.toArray((Collection)Objects.requireNonNull(inputChannels, "inputChannels is null"));
        this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null");
        this.maskBuilder = Objects.requireNonNull(maskBuilder, "maskBuilder is null");
        Preconditions.checkArgument((step.isInputRaw() || inputChannels.size() == 1 ? 1 : 0) != 0, (Object)"expected 1 input channel for intermediate aggregation");
    }

    public long getEstimatedSize() {
        return this.accumulator.getEstimatedSize();
    }

    public Type getType() {
        if (this.step.isOutputPartial()) {
            return this.intermediateType;
        }
        return this.finalType;
    }

    public void processPage(int groupCount, int[] groupIds, Page page) {
        this.accumulator.setGroupCount(groupCount);
        if (this.step.isInputRaw()) {
            AggregationMask mask;
            Page arguments = page.getColumns(this.inputChannels);
            Optional<Block> maskBlock = Optional.empty();
            if (this.maskChannel.isPresent()) {
                maskBlock = Optional.of(page.getBlock(this.maskChannel.getAsInt()));
            }
            if ((mask = this.maskBuilder.buildAggregationMask(arguments, maskBlock)).isSelectNone()) {
                return;
            }
            this.accumulator.addInput(groupIds, arguments, mask);
        } else {
            this.accumulator.addIntermediate(groupIds, page.getBlock(this.inputChannels[0]));
        }
    }

    public void prepareFinal() {
        this.accumulator.prepareFinal();
    }

    public void evaluate(int groupId, BlockBuilder output) {
        if (this.step.isOutputPartial()) {
            this.accumulator.evaluateIntermediate(groupId, output);
        } else {
            this.accumulator.evaluateFinal(groupId, output);
        }
    }

    public void setSpillOutput() {
        this.step = AggregationNode.Step.partialOutput(this.step);
    }

    public Type getSpillType() {
        return this.intermediateType;
    }
}

