/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.NumericHistogram;
import io.trino.operator.aggregation.NumericHistogramStateFactory;
import io.trino.operator.aggregation.state.DoubleHistogramStateSerializer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateMetadata;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DoubleType;
import io.trino.util.Failures;
import java.util.Map;

@AggregationFunction(value="numeric_histogram")
public final class DoubleHistogramAggregation {
    public static final int ENTRY_BUFFER_SIZE = 100;

    private DoubleHistogramAggregation() {
    }

    @InputFunction
    public static void add(@AggregationState State state, @SqlType(value="bigint") long buckets, @SqlType(value="double") double value, @SqlType(value="double") double weight) {
        NumericHistogram histogram = state.get();
        if (histogram == null) {
            Failures.checkCondition(buckets >= 2L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "numeric_histogram bucket count must be greater than one", new Object[0]);
            histogram = new NumericHistogram(Math.toIntExact(buckets), 100);
            state.set(histogram);
        }
        histogram.add(value, weight);
    }

    @InputFunction
    public static void add(@AggregationState State state, @SqlType(value="bigint") long buckets, @SqlType(value="double") double value) {
        DoubleHistogramAggregation.add(state, buckets, value, 1.0);
    }

    @CombineFunction
    public static void merge(@AggregationState State state, State other) {
        NumericHistogram input = other.get();
        NumericHistogram previous = state.get();
        if (previous == null) {
            state.set(input);
        } else {
            previous.mergeWith(input);
        }
    }

    @OutputFunction(value="map(double,double)")
    public static void output(@AggregationState State state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            Map<Double, Double> value = state.get().getBuckets();
            ((MapBlockBuilder)out).buildEntry((keyBuilder, valueBuilder) -> {
                for (Map.Entry entry : value.entrySet()) {
                    DoubleType.DOUBLE.writeDouble(keyBuilder, ((Double)entry.getKey()).doubleValue());
                    DoubleType.DOUBLE.writeDouble(valueBuilder, ((Double)entry.getValue()).doubleValue());
                }
            });
        }
    }

    @AccumulatorStateMetadata(stateSerializerClass=DoubleHistogramStateSerializer.class, stateFactoryClass=NumericHistogramStateFactory.class)
    public static interface State
    extends AccumulatorState {
        public NumericHistogram get();

        public void set(NumericHistogram var1);
    }
}

