/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InOut;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;

@AggregationFunction(value="any_value", alias={"arbitrary"})
@Description(value="Return an arbitrary non-null input value")
public final class ArbitraryAggregationFunction {
    private ArbitraryAggregationFunction() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState(value={"T"}) InOut state, @BlockPosition @SqlType(value="T") Block block, @BlockIndex int position) throws Throwable {
        if (state.isNull()) {
            state.set(block, position);
        }
    }

    @CombineFunction
    public static void combine(@AggregationState(value={"T"}) InOut state, @AggregationState(value={"T"}) InOut otherState) throws Throwable {
        if (state.isNull()) {
            state.set(otherState);
        }
    }

    @OutputFunction(value="T")
    public static void output(@AggregationState(value={"T"}) InOut state, BlockBuilder out) {
        state.get(out);
    }
}

