/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.operator.OperatorInfo;
import io.trino.operator.PagesIndex;
import io.trino.operator.window.WindowPartition;
import io.trino.spi.Mergeable;
import java.util.List;
import java.util.Optional;

public class WindowInfo
implements Mergeable<WindowInfo>,
OperatorInfo {
    private static final WindowInfo EMPTY_INFO = new WindowInfo((List<DriverWindowInfo>)ImmutableList.of());
    private final List<DriverWindowInfo> windowInfos;

    public static WindowInfo emptyInfo() {
        return EMPTY_INFO;
    }

    @JsonCreator
    public WindowInfo(@JsonProperty(value="windowInfos") List<DriverWindowInfo> windowInfos) {
        this.windowInfos = ImmutableList.copyOf(windowInfos);
    }

    @JsonProperty
    public List<DriverWindowInfo> getWindowInfos() {
        return this.windowInfos;
    }

    public WindowInfo mergeWith(WindowInfo other) {
        int otherSize = other.windowInfos.size();
        if (otherSize == 0) {
            return this;
        }
        int thisSize = this.windowInfos.size();
        if (thisSize == 0) {
            return other;
        }
        return new WindowInfo((List<DriverWindowInfo>)ImmutableList.builderWithExpectedSize((int)(thisSize + otherSize)).addAll(this.windowInfos).addAll(other.windowInfos).build());
    }

    @Immutable
    public static class IndexInfo {
        private final long totalRowsCount;
        private final long sizeInBytes;
        private final double sumSquaredDifferencesSizeInPartition;
        private final long numberOfPartitions;

        public IndexInfo(long totalRowsCount, long sizeInBytes, double sumSquaredDifferencesSizeInPartition, long numberOfPartitions) {
            this.totalRowsCount = totalRowsCount;
            this.sizeInBytes = sizeInBytes;
            this.sumSquaredDifferencesSizeInPartition = sumSquaredDifferencesSizeInPartition;
            this.numberOfPartitions = numberOfPartitions;
        }

        public long getTotalRowsCount() {
            return this.totalRowsCount;
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public double getSumSquaredDifferencesSizeInPartition() {
            return this.sumSquaredDifferencesSizeInPartition;
        }

        public long getNumberOfPartitions() {
            return this.numberOfPartitions;
        }
    }

    private static class IndexInfoBuilder {
        private final long rowsNumber;
        private final long sizeInBytes;
        private final ImmutableList.Builder<Integer> partitionsSizes = ImmutableList.builder();

        public IndexInfoBuilder(long rowsNumber, long sizeInBytes) {
            this.rowsNumber = rowsNumber;
            this.sizeInBytes = sizeInBytes;
        }

        public void addPartition(WindowPartition partition) {
            this.partitionsSizes.add((Object)(partition.getPartitionEnd() - partition.getPartitionStart()));
        }

        public Optional<IndexInfo> build() {
            ImmutableList partitions = this.partitionsSizes.build();
            if (partitions.size() == 0) {
                return Optional.empty();
            }
            double avgSize = partitions.stream().mapToLong(Integer::longValue).average().getAsDouble();
            double squaredDifferences = partitions.stream().mapToDouble(size -> Math.pow((double)size.intValue() - avgSize, 2.0)).sum();
            if (partitions.stream().mapToLong(Integer::longValue).sum() != this.rowsNumber) {
                return Optional.empty();
            }
            return Optional.of(new IndexInfo(this.rowsNumber, this.sizeInBytes, squaredDifferences, partitions.size()));
        }
    }

    @Immutable
    public static class DriverWindowInfo {
        private final double sumSquaredDifferencesPositionsOfIndex;
        private final double sumSquaredDifferencesSizeOfIndex;
        private final double sumSquaredDifferencesSizeInPartition;
        private final long totalPartitionsCount;
        private final long totalRowsCount;
        private final long numberOfIndexes;

        @JsonCreator
        public DriverWindowInfo(@JsonProperty(value="sumSquaredDifferencesPositionsOfIndex") double sumSquaredDifferencesPositionsOfIndex, @JsonProperty(value="sumSquaredDifferencesSizeOfIndex") double sumSquaredDifferencesSizeOfIndex, @JsonProperty(value="sumSquaredDifferencesSizeInPartition") double sumSquaredDifferencesSizeInPartition, @JsonProperty(value="totalPartitionsCount") long totalPartitionsCount, @JsonProperty(value="totalRowsCount") long totalRowsCount, @JsonProperty(value="numberOfIndexes") long numberOfIndexes) {
            this.sumSquaredDifferencesPositionsOfIndex = sumSquaredDifferencesPositionsOfIndex;
            this.sumSquaredDifferencesSizeOfIndex = sumSquaredDifferencesSizeOfIndex;
            this.sumSquaredDifferencesSizeInPartition = sumSquaredDifferencesSizeInPartition;
            this.totalPartitionsCount = totalPartitionsCount;
            this.totalRowsCount = totalRowsCount;
            this.numberOfIndexes = numberOfIndexes;
        }

        @JsonProperty
        public double getSumSquaredDifferencesPositionsOfIndex() {
            return this.sumSquaredDifferencesPositionsOfIndex;
        }

        @JsonProperty
        public double getSumSquaredDifferencesSizeOfIndex() {
            return this.sumSquaredDifferencesSizeOfIndex;
        }

        @JsonProperty
        public double getSumSquaredDifferencesSizeInPartition() {
            return this.sumSquaredDifferencesSizeInPartition;
        }

        @JsonProperty
        public long getTotalPartitionsCount() {
            return this.totalPartitionsCount;
        }

        @JsonProperty
        public long getTotalRowsCount() {
            return this.totalRowsCount;
        }

        @JsonProperty
        public long getNumberOfIndexes() {
            return this.numberOfIndexes;
        }
    }

    static class DriverWindowInfoBuilder {
        private final ImmutableList.Builder<IndexInfo> indexInfosBuilder = ImmutableList.builder();
        private IndexInfoBuilder currentIndexInfoBuilder;

        DriverWindowInfoBuilder() {
        }

        public void addIndex(PagesIndex index) {
            if (this.currentIndexInfoBuilder != null) {
                Optional<IndexInfo> indexInfo = this.currentIndexInfoBuilder.build();
                indexInfo.ifPresent(arg_0 -> this.indexInfosBuilder.add(arg_0));
            }
            this.currentIndexInfoBuilder = new IndexInfoBuilder(index.getPositionCount(), index.getEstimatedSize().toBytes());
        }

        public void addPartition(WindowPartition partition) {
            Preconditions.checkState((this.currentIndexInfoBuilder != null ? 1 : 0) != 0, (Object)"addIndex must be called before addPartition");
            this.currentIndexInfoBuilder.addPartition(partition);
        }

        public DriverWindowInfo build() {
            ImmutableList indexInfos;
            if (this.currentIndexInfoBuilder != null) {
                Optional<IndexInfo> indexInfo = this.currentIndexInfoBuilder.build();
                indexInfo.ifPresent(arg_0 -> this.indexInfosBuilder.add(arg_0));
                this.currentIndexInfoBuilder = null;
            }
            if ((indexInfos = this.indexInfosBuilder.build()).size() == 0) {
                return new DriverWindowInfo(0.0, 0.0, 0.0, 0L, 0L, 0L);
            }
            long totalRowsCount = indexInfos.stream().mapToLong(IndexInfo::getTotalRowsCount).sum();
            double averageIndexPositions = (double)totalRowsCount / (double)indexInfos.size();
            double squaredDifferencesPositionsOfIndex = indexInfos.stream().mapToDouble(index -> Math.pow((double)index.getTotalRowsCount() - averageIndexPositions, 2.0)).sum();
            double averageIndexSize = indexInfos.stream().mapToLong(IndexInfo::getSizeInBytes).average().getAsDouble();
            double squaredDifferencesSizeOfIndex = indexInfos.stream().mapToDouble(index -> Math.pow((double)index.getSizeInBytes() - averageIndexSize, 2.0)).sum();
            double squaredDifferencesSizeInPartition = indexInfos.stream().mapToDouble(IndexInfo::getSumSquaredDifferencesSizeInPartition).sum();
            long totalPartitionsCount = indexInfos.stream().mapToLong(IndexInfo::getNumberOfPartitions).sum();
            return new DriverWindowInfo(squaredDifferencesPositionsOfIndex, squaredDifferencesSizeOfIndex, squaredDifferencesSizeInPartition, totalPartitionsCount, totalRowsCount, indexInfos.size());
        }
    }
}

