/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.execution.TaskId;
import io.trino.memory.QueryContextVisitor;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.operator.BlockedReason;
import io.trino.operator.DriverStats;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.OperationTimer;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorStats;
import io.trino.operator.PipelineContext;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

public class DriverContext {
    private final PipelineContext pipelineContext;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final AtomicBoolean finished = new AtomicBoolean();
    private final DateTime createdTime = DateTime.now();
    private final long createNanos = System.nanoTime();
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong endNanos = new AtomicLong();
    private final OperationTimer.OperationTiming overallTiming = new OperationTimer.OperationTiming();
    private final AtomicReference<BlockedMonitor> blockedMonitor = new AtomicReference();
    private final AtomicLong blockedWallNanos = new AtomicLong();
    private final AtomicReference<DateTime> executionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> executionEndTime = new AtomicReference();
    private final MemoryTrackingContext driverMemoryContext;
    private final DriverYieldSignal yieldSignal;
    private final List<OperatorContext> operatorContexts = new CopyOnWriteArrayList<OperatorContext>();
    private final long splitWeight;

    public DriverContext(PipelineContext pipelineContext, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, MemoryTrackingContext driverMemoryContext, long splitWeight) {
        this.pipelineContext = Objects.requireNonNull(pipelineContext, "pipelineContext is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "yieldExecutor is null");
        this.driverMemoryContext = Objects.requireNonNull(driverMemoryContext, "driverMemoryContext is null");
        this.yieldSignal = new DriverYieldSignal();
        this.splitWeight = splitWeight;
        Preconditions.checkArgument((splitWeight >= 0L ? 1 : 0) != 0, (String)"splitWeight must be >= 0, found: %s", (long)splitWeight);
    }

    public TaskId getTaskId() {
        return this.pipelineContext.getTaskId();
    }

    public long getSplitWeight() {
        return this.splitWeight;
    }

    public OperatorContext addOperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        for (OperatorContext operatorContext : this.operatorContexts) {
            Preconditions.checkArgument((operatorId != operatorContext.getOperatorId() ? 1 : 0) != 0, (String)"A context already exists for operatorId %s", (int)operatorId);
        }
        OperatorContext operatorContext = new OperatorContext(operatorId, planNodeId, operatorType, this, this.notificationExecutor, this.driverMemoryContext.newMemoryTrackingContext());
        this.operatorContexts.add(operatorContext);
        return operatorContext;
    }

    public List<OperatorContext> getOperatorContexts() {
        return ImmutableList.copyOf(this.operatorContexts);
    }

    public PipelineContext getPipelineContext() {
        return this.pipelineContext;
    }

    public Session getSession() {
        return this.pipelineContext.getSession();
    }

    public void startProcessTimer() {
        if (this.executionStartTime.get() == null && this.startNanos.compareAndSet(0L, System.nanoTime())) {
            this.executionStartTime.set(DateTime.now());
            this.pipelineContext.start();
        }
    }

    public void recordProcessed(OperationTimer operationTimer) {
        operationTimer.end(this.overallTiming);
    }

    public void recordBlocked(ListenableFuture<Void> blocked) {
        Objects.requireNonNull(blocked, "blocked is null");
        BlockedMonitor monitor = new BlockedMonitor();
        BlockedMonitor oldMonitor = this.blockedMonitor.getAndSet(monitor);
        if (oldMonitor != null) {
            oldMonitor.run();
        }
        blocked.addListener((Runnable)monitor, this.notificationExecutor);
    }

    public void finished() {
        if (!this.finished.compareAndSet(false, true)) {
            return;
        }
        this.endNanos.set(System.nanoTime());
        this.executionEndTime.set(DateTime.now());
        this.pipelineContext.driverFinished(this);
    }

    public void failed(Throwable cause) {
        if (this.finished.compareAndSet(false, true)) {
            this.pipelineContext.driverFailed(cause);
        }
    }

    public boolean isTerminatingOrDone() {
        return this.finished.get() || this.pipelineContext.isTerminatingOrDone();
    }

    public ListenableFuture<Void> reserveSpill(long bytes) {
        return this.pipelineContext.reserveSpill(bytes);
    }

    public void freeSpill(long bytes) {
        if (bytes == 0L) {
            return;
        }
        Preconditions.checkArgument((bytes > 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.pipelineContext.freeSpill(bytes);
    }

    public DriverYieldSignal getYieldSignal() {
        return this.yieldSignal;
    }

    public long getMemoryUsage() {
        return this.driverMemoryContext.getUserMemory();
    }

    public long getRevocableMemoryUsage() {
        return this.driverMemoryContext.getRevocableMemory();
    }

    public boolean isPerOperatorCpuTimerEnabled() {
        return this.pipelineContext.isPerOperatorCpuTimerEnabled();
    }

    public boolean isCpuTimerEnabled() {
        return this.pipelineContext.isCpuTimerEnabled();
    }

    public CounterStat getInputDataSize() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getFirst(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getInputDataSize();
        }
        return new CounterStat();
    }

    public CounterStat getInputPositions() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getFirst(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getInputPositions();
        }
        return new CounterStat();
    }

    public CounterStat getOutputDataSize() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getLast(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getOutputDataSize();
        }
        return new CounterStat();
    }

    public CounterStat getOutputPositions() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getLast(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getOutputPositions();
        }
        return new CounterStat();
    }

    public long getWriterInputDataSize() {
        long writerInputDataSize = 0L;
        for (OperatorContext context : this.operatorContexts) {
            writerInputDataSize += context.getWriterInputDataSize();
        }
        return writerInputDataSize;
    }

    public long getPhysicalWrittenDataSize() {
        long physicalWrittenBytes = 0L;
        for (OperatorContext context : this.operatorContexts) {
            physicalWrittenBytes += context.getPhysicalWrittenDataSize();
        }
        return physicalWrittenBytes;
    }

    public boolean isExecutionStarted() {
        return this.executionStartTime.get() != null;
    }

    public boolean isFullyBlocked() {
        return this.blockedMonitor.get() != null;
    }

    public List<OperatorStats> getOperatorStats() {
        return (List)this.operatorContexts.stream().flatMap(operatorContext -> operatorContext.getNestedOperatorStats().stream()).collect(ImmutableList.toImmutableList());
    }

    public DriverStats getDriverStats() {
        Duration outputBlockedTime;
        long outputPositions;
        DataSize outputDataSize;
        Duration inputBlockedTime;
        long processedInputPositions;
        DataSize processedInputDataSize;
        Duration rawInputReadTime;
        long rawInputPositions;
        DataSize rawInputDataSize;
        long internalNetworkInputPositions;
        DataSize internalNetworkInputDataSize;
        Duration physicalInputReadTime;
        long physicalInputPositions;
        DataSize physicalInputDataSize;
        DateTime executionStartTime;
        long totalScheduledTime = this.overallTiming.getWallNanos();
        long totalCpuTime = this.overallTiming.getCpuNanos();
        long totalBlockedTime = this.blockedWallNanos.get();
        BlockedMonitor blockedMonitor = this.blockedMonitor.get();
        if (blockedMonitor != null) {
            totalBlockedTime += blockedMonitor.getBlockedTime();
        }
        Duration queuedTime = new Duration((double)DriverContext.nanosBetween(this.createNanos, (executionStartTime = this.executionStartTime.get()) == null ? System.nanoTime() : this.startNanos.get()), TimeUnit.NANOSECONDS);
        DateTime executionEndTime = this.executionEndTime.get();
        Duration elapsedTime = new Duration((double)DriverContext.nanosBetween(this.createNanos, executionEndTime == null ? System.nanoTime() : this.endNanos.get()), TimeUnit.NANOSECONDS);
        List<OperatorStats> operators = this.getOperatorStats();
        OperatorStats inputOperator = (OperatorStats)Iterables.getFirst(operators, null);
        if (inputOperator != null) {
            physicalInputDataSize = inputOperator.getPhysicalInputDataSize();
            physicalInputPositions = inputOperator.getPhysicalInputPositions();
            physicalInputReadTime = inputOperator.getPhysicalInputReadTime();
            internalNetworkInputDataSize = inputOperator.getInternalNetworkInputDataSize();
            internalNetworkInputPositions = inputOperator.getInternalNetworkInputPositions();
            rawInputDataSize = inputOperator.getRawInputDataSize();
            rawInputPositions = inputOperator.getInputPositions();
            rawInputReadTime = inputOperator.getAddInputWall();
            processedInputDataSize = inputOperator.getInputDataSize();
            processedInputPositions = inputOperator.getInputPositions();
            inputBlockedTime = inputOperator.getBlockedWall();
            OperatorStats outputOperator = Objects.requireNonNull((OperatorStats)Iterables.getLast(operators, null));
            outputDataSize = outputOperator.getOutputDataSize();
            outputPositions = outputOperator.getOutputPositions();
            outputBlockedTime = outputOperator.getBlockedWall();
        } else {
            physicalInputDataSize = DataSize.ofBytes((long)0L);
            physicalInputPositions = 0L;
            physicalInputReadTime = new Duration(0.0, TimeUnit.MILLISECONDS);
            internalNetworkInputDataSize = DataSize.ofBytes((long)0L);
            internalNetworkInputPositions = 0L;
            rawInputDataSize = DataSize.ofBytes((long)0L);
            rawInputPositions = 0L;
            rawInputReadTime = new Duration(0.0, TimeUnit.MILLISECONDS);
            processedInputDataSize = DataSize.ofBytes((long)0L);
            processedInputPositions = 0L;
            inputBlockedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
            outputDataSize = DataSize.ofBytes((long)0L);
            outputPositions = 0L;
            outputBlockedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        long physicalWrittenDataSize = 0L;
        for (OperatorStats operator : operators) {
            physicalWrittenDataSize += operator.getPhysicalWrittenDataSize().toBytes();
            if (!operator.getBlockedReason().isPresent()) continue;
            builder.add((Object)operator.getBlockedReason().get());
        }
        return new DriverStats(this.createdTime, executionStartTime, executionEndTime, queuedTime.convertToMostSuccinctTimeUnit(), elapsedTime.convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)this.driverMemoryContext.getUserMemory()), DataSize.succinctBytes((long)this.driverMemoryContext.getRevocableMemory()), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), blockedMonitor != null, (Set<BlockedReason>)builder.build(), physicalInputDataSize.succinct(), physicalInputPositions, physicalInputReadTime, internalNetworkInputDataSize.succinct(), internalNetworkInputPositions, rawInputDataSize.succinct(), rawInputPositions, rawInputReadTime, processedInputDataSize.succinct(), processedInputPositions, inputBlockedTime, outputDataSize.succinct(), outputPositions, outputBlockedTime, DataSize.succinctBytes((long)physicalWrittenDataSize), operators);
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitDriverContext(this, context);
    }

    public <C, R> List<R> acceptChildren(QueryContextVisitor<C, R> visitor, C context) {
        return this.operatorContexts.stream().map(operatorContext -> operatorContext.accept(visitor, context)).collect(Collectors.toList());
    }

    public ScheduledExecutorService getYieldExecutor() {
        return this.yieldExecutor;
    }

    private static long nanosBetween(long start, long end) {
        return Math.max(0L, end - start);
    }

    private class BlockedMonitor
    implements Runnable {
        private final long start = System.nanoTime();
        private boolean finished;

        private BlockedMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BlockedMonitor blockedMonitor = this;
            synchronized (blockedMonitor) {
                if (this.finished) {
                    return;
                }
                this.finished = true;
                DriverContext.this.blockedMonitor.compareAndSet(this, null);
                DriverContext.this.blockedWallNanos.getAndAdd(this.getBlockedTime());
            }
        }

        public long getBlockedTime() {
            return DriverContext.nanosBetween(this.start, System.nanoTime());
        }
    }
}

