/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.operator.MergeRowChangeProcessor;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class DeleteAndInsertMergeProcessor
implements MergeRowChangeProcessor {
    private final List<Type> dataColumnTypes;
    private final Type rowIdType;
    private final int rowIdChannel;
    private final int mergeRowChannel;
    private final List<Integer> dataColumnChannels;
    private final int redistributionColumnCount;
    private final List<Integer> redistributionChannelNumbers;

    public DeleteAndInsertMergeProcessor(List<Type> dataColumnTypes, Type rowIdType, int rowIdChannel, int mergeRowChannel, List<Integer> redistributionChannelNumbers, List<Integer> dataColumnChannels) {
        this.dataColumnTypes = Objects.requireNonNull(dataColumnTypes, "dataColumnTypes is null");
        this.rowIdType = Objects.requireNonNull(rowIdType, "rowIdType is null");
        this.rowIdChannel = rowIdChannel;
        this.mergeRowChannel = mergeRowChannel;
        this.redistributionColumnCount = redistributionChannelNumbers.size();
        int redistributionSourceIndex = 0;
        this.dataColumnChannels = Objects.requireNonNull(dataColumnChannels, "dataColumnChannels is null");
        ImmutableList.Builder redistributionChannelNumbersBuilder = ImmutableList.builder();
        for (int dataColumnChannel : dataColumnChannels) {
            if (redistributionChannelNumbers.contains(dataColumnChannel)) {
                redistributionChannelNumbersBuilder.add((Object)redistributionSourceIndex);
                ++redistributionSourceIndex;
                continue;
            }
            redistributionChannelNumbersBuilder.add((Object)-1);
        }
        this.redistributionChannelNumbers = redistributionChannelNumbersBuilder.build();
    }

    @JsonProperty
    public List<Type> getDataColumnTypes() {
        return this.dataColumnTypes;
    }

    @JsonProperty
    public Type getRowIdType() {
        return this.rowIdType;
    }

    @Override
    public Page transformPage(Page inputPage) {
        Objects.requireNonNull(inputPage, "inputPage is null");
        int inputChannelCount = inputPage.getChannelCount();
        Preconditions.checkArgument((inputChannelCount >= 2 + this.redistributionColumnCount ? 1 : 0) != 0, (String)"inputPage channelCount (%s) should be >= 2 + partition columns size (%s)", (int)inputChannelCount, (int)this.redistributionColumnCount);
        int originalPositionCount = inputPage.getPositionCount();
        Preconditions.checkArgument((originalPositionCount > 0 ? 1 : 0) != 0, (String)"originalPositionCount should be > 0, but is %s", (int)originalPositionCount);
        ColumnarRow mergeRow = ColumnarRow.toColumnarRow((Block)inputPage.getBlock(this.mergeRowChannel));
        Block operationChannelBlock = mergeRow.getField(mergeRow.getFieldCount() - 2);
        int updatePositions = 0;
        int insertPositions = 0;
        int deletePositions = 0;
        block7: for (int position = 0; position < originalPositionCount; ++position) {
            byte operation = TinyintType.TINYINT.getByte(operationChannelBlock, position);
            switch (operation) {
                case -1: {
                    continue block7;
                }
                case 1: {
                    ++insertPositions;
                    continue block7;
                }
                case 2: {
                    ++deletePositions;
                    continue block7;
                }
                case 3: {
                    ++updatePositions;
                    continue block7;
                }
                case 4: 
                case 5: {
                    throw new IllegalArgumentException("Unexpected operator number: " + operation);
                }
                default: {
                    throw new IllegalArgumentException("Unknown operator number: " + operation);
                }
            }
        }
        int totalPositions = insertPositions + deletePositions + 2 * updatePositions;
        ImmutableList pageTypes = ImmutableList.builder().addAll(this.dataColumnTypes).add((Object)TinyintType.TINYINT).add((Object)this.rowIdType).add((Object)TinyintType.TINYINT).build();
        PageBuilder pageBuilder = new PageBuilder(totalPositions, (List)pageTypes);
        for (int position = 0; position < originalPositionCount; ++position) {
            byte operation = TinyintType.TINYINT.getByte(operationChannelBlock, position);
            if (operation == -1) continue;
            if (operation == 2 || operation == 3) {
                this.addDeleteRow(pageBuilder, inputPage, position, operation != 2);
            }
            if (operation != 1 && operation != 3) continue;
            this.addInsertRow(pageBuilder, mergeRow, position, operation != 1);
        }
        Page page = pageBuilder.build();
        Verify.verify((page.getPositionCount() == totalPositions ? 1 : 0) != 0, (String)"page positions (%s) is not equal to (%s)", (int)page.getPositionCount(), (int)totalPositions);
        return page;
    }

    private void addDeleteRow(PageBuilder pageBuilder, Page originalPage, int position, boolean causedByUpdate) {
        for (int targetChannel : this.dataColumnChannels) {
            Type columnType = this.dataColumnTypes.get(targetChannel);
            BlockBuilder targetBlock = pageBuilder.getBlockBuilder(targetChannel);
            int redistributionChannelNumber = this.redistributionChannelNumbers.get(targetChannel);
            if (this.redistributionChannelNumbers.get(targetChannel) >= 0) {
                columnType.appendTo(originalPage.getBlock(redistributionChannelNumber), position, targetBlock);
                continue;
            }
            targetBlock.appendNull();
        }
        TinyintType.TINYINT.writeLong(pageBuilder.getBlockBuilder(this.dataColumnChannels.size()), causedByUpdate ? 5L : 2L);
        this.rowIdType.appendTo(originalPage.getBlock(this.rowIdChannel), position, pageBuilder.getBlockBuilder(this.dataColumnChannels.size() + 1));
        TinyintType.TINYINT.writeLong(pageBuilder.getBlockBuilder(this.dataColumnChannels.size() + 2), 0L);
        pageBuilder.declarePosition();
    }

    private void addInsertRow(PageBuilder pageBuilder, ColumnarRow mergeCaseBlock, int position, boolean causedByUpdate) {
        for (int targetChannel : this.dataColumnChannels) {
            Type columnType = this.dataColumnTypes.get(targetChannel);
            BlockBuilder targetBlock = pageBuilder.getBlockBuilder(targetChannel);
            columnType.appendTo(mergeCaseBlock.getField(targetChannel), position, targetBlock);
        }
        TinyintType.TINYINT.writeLong(pageBuilder.getBlockBuilder(this.dataColumnChannels.size()), causedByUpdate ? 4L : 1L);
        pageBuilder.getBlockBuilder(this.dataColumnChannels.size() + 1).appendNull();
        TinyintType.TINYINT.writeLong(pageBuilder.getBlockBuilder(this.dataColumnChannels.size() + 2), causedByUpdate ? 1L : 0L);
        pageBuilder.declarePosition();
    }
}

