/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.Session;
import io.trino.connector.CatalogServiceProvider;
import io.trino.metadata.CatalogTableProcedures;
import io.trino.metadata.PropertyUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.session.PropertyMetadata;
import io.trino.sql.PlannerContext;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Property;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TableProceduresPropertyManager {
    private final CatalogServiceProvider<CatalogTableProcedures> tableProceduresProvider;

    public TableProceduresPropertyManager(CatalogServiceProvider<CatalogTableProcedures> tableProceduresProvider) {
        this.tableProceduresProvider = Objects.requireNonNull(tableProceduresProvider, "tableProceduresProvider is null");
    }

    public Map<String, Object> getProperties(String catalogName, CatalogHandle catalogHandle, String procedureName, Map<String, Expression> sqlPropertyValues, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        TableProcedureMetadata tableProcedure = this.tableProceduresProvider.getService(catalogHandle).getTableProcedure(procedureName);
        ImmutableMap supportedProperties = Maps.uniqueIndex((Iterable)tableProcedure.getProperties(), PropertyMetadata::getName);
        Map<String, Optional<Object>> propertyValues = PropertyUtil.evaluateProperties((Iterable)sqlPropertyValues.entrySet().stream().map(entry -> new Property(new Identifier((String)entry.getKey()), (Expression)entry.getValue())).collect(ImmutableList.toImmutableList()), session, plannerContext, accessControl, parameters, true, supportedProperties, (ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, String.format("catalog '%s' table procedure '%s' property", catalogName, procedureName));
        return (Map)propertyValues.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Optional)entry.getValue()).orElseThrow()));
    }
}

