/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.Maps;
import com.google.errorprone.annotations.ThreadSafe;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.function.table.ConnectorTableFunction;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@ThreadSafe
public class CatalogTableFunctions {
    private final Map<SchemaFunctionName, ConnectorTableFunction> functions;

    public CatalogTableFunctions(Collection<ConnectorTableFunction> functions) {
        Objects.requireNonNull(functions, "functions is null");
        this.functions = Maps.uniqueIndex(functions, function -> CatalogTableFunctions.lowerCaseSchemaFunctionName(new SchemaFunctionName(function.getSchema(), function.getName())));
    }

    public Optional<ConnectorTableFunction> getTableFunction(SchemaFunctionName schemaFunctionName) {
        return Optional.ofNullable(this.functions.get(CatalogTableFunctions.lowerCaseSchemaFunctionName(schemaFunctionName)));
    }

    private static SchemaFunctionName lowerCaseSchemaFunctionName(SchemaFunctionName name) {
        return new SchemaFunctionName(name.getSchemaName().toLowerCase(Locale.ENGLISH), name.getFunctionName().toLowerCase(Locale.ENGLISH));
    }
}

