/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.inject.Inject;
import io.trino.memory.LocalMemoryManager;
import io.trino.memory.MemoryInfo;
import io.trino.server.security.ResourceSecurity;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Objects;

@Path(value="/v1/memory")
public class MemoryResource {
    private final LocalMemoryManager memoryManager;

    @Inject
    public MemoryResource(LocalMemoryManager memoryManager) {
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.INTERNAL_ONLY)
    @GET
    @Produces(value={"application/json"})
    public MemoryInfo getMemoryInfo() {
        return this.memoryManager.getInfo();
    }
}

