/*
 * Decompiled with CFR 0.152.
 */
package io.trino.likematcher;

import io.trino.likematcher.Matcher;
import io.trino.likematcher.Pattern;
import java.util.Arrays;
import java.util.List;

final class NfaMatcher
implements Matcher {
    private static final int ANY = -1;
    private static final int NONE = -2;
    private static final int INVALID_CODEPOINT = -1;
    private final boolean exact;
    private final boolean[] loopback;
    private final int[] match;
    private final int acceptState;
    private final int stateCount;

    public NfaMatcher(List<Pattern> pattern, int start, int end, boolean exact) {
        this.exact = exact;
        this.stateCount = NfaMatcher.calculateStateCount(pattern, start, end);
        this.loopback = new boolean[this.stateCount];
        this.match = new int[this.stateCount];
        Arrays.fill(this.match, -2);
        this.acceptState = this.stateCount - 1;
        int state = 0;
        for (int j = start; j <= end; ++j) {
            int i;
            Pattern element = pattern.get(j);
            if (element instanceof Pattern.Literal) {
                Pattern.Literal literal = (Pattern.Literal)element;
                for (i = 0; i < literal.value().length(); ++i) {
                    this.match[state++] = literal.value().charAt(i);
                }
                continue;
            }
            if (element instanceof Pattern.Any) {
                Pattern.Any any = (Pattern.Any)element;
                for (i = 0; i < any.length(); ++i) {
                    this.match[state++] = -1;
                }
                continue;
            }
            if (!(element instanceof Pattern.ZeroOrMore)) continue;
            this.loopback[state] = true;
        }
    }

    private static int calculateStateCount(List<Pattern> pattern, int start, int end) {
        int states = 1;
        for (int i = start; i <= end; ++i) {
            Pattern element = pattern.get(i);
            if (element instanceof Pattern.Literal) {
                Pattern.Literal literal = (Pattern.Literal)element;
                states += literal.value().length();
                continue;
            }
            if (!(element instanceof Pattern.Any)) continue;
            Pattern.Any any = (Pattern.Any)element;
            states += any.length();
        }
        return states;
    }

    @Override
    public boolean match(byte[] input, int offset, int length) {
        boolean[] seen = new boolean[this.stateCount + 1];
        int[] currentStates = new int[this.stateCount];
        int[] nextStates = new int[this.stateCount];
        int currentStatesIndex = 0;
        currentStates[currentStatesIndex++] = 0;
        int limit = offset + length;
        int current = offset;
        boolean accept = false;
        while (current < limit) {
            int codepoint = -1;
            int header = input[current] & 0xFF;
            if (header < 128) {
                codepoint = header;
                ++current;
            } else if ((header & 0xE0) == 192) {
                if (current + 1 < limit) {
                    codepoint = (header & 0x1F) << 6 | input[current + 1] & 0x3F;
                    current += 2;
                }
            } else if ((header & 0xF0) == 224) {
                if (current + 2 < limit) {
                    codepoint = (header & 0xF) << 12 | (input[current + 1] & 0x3F) << 6 | input[current + 2] & 0x3F;
                    current += 3;
                }
            } else if ((header & 0xF8) == 240 && current + 3 < limit) {
                codepoint = (header & 7) << 18 | (input[current + 1] & 0x3F) << 12 | (input[current + 2] & 0x3F) << 6 | input[current + 3] & 0x3F;
                current += 4;
            }
            if (codepoint == -1) {
                return false;
            }
            accept = false;
            int nextStatesIndex = 0;
            Arrays.fill(seen, false);
            for (int i = 0; i < currentStatesIndex; ++i) {
                int next;
                int state = currentStates[i];
                if (!seen[state] && this.loopback[state]) {
                    nextStates[nextStatesIndex++] = state;
                    accept |= state == this.acceptState;
                    seen[state] = true;
                }
                if (seen[next = state + 1] || this.match[state] != -1 && this.match[state] != codepoint) continue;
                nextStates[nextStatesIndex++] = next;
                accept |= next == this.acceptState;
                seen[next] = true;
            }
            if (nextStatesIndex == 0) {
                return false;
            }
            if (!this.exact && accept) {
                return true;
            }
            int[] tmp = currentStates;
            currentStates = nextStates;
            nextStates = tmp;
            currentStatesIndex = nextStatesIndex;
        }
        return accept;
    }
}

