/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import java.util.Objects;
import java.util.Optional;

public record IrLiteral(Optional<Type> type, Object value) implements IrPathNode
{
    public IrLiteral {
        Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((boolean)type.isPresent(), (Object)"type is empty");
        Objects.requireNonNull(value, "value is null");
    }

    @Deprecated
    @JsonCreator
    public static IrLiteral fromJson(@JsonProperty(value="type") Type type, @JsonProperty(value="valueAsBlock") Block value) {
        Preconditions.checkArgument((value.getPositionCount() == 1 ? 1 : 0) != 0);
        return new IrLiteral(Optional.of(type), TypeUtils.readNativeValue((Type)type, (Block)value, (int)0));
    }

    @Override
    public <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrLiteral(this, context);
    }

    @JsonProperty
    public Block getValueAsBlock() {
        return Utils.nativeValueToBlock((Type)this.type().orElseThrow(), (Object)this.value);
    }
}

