/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public record IrArithmeticBinary(Operator operator, IrPathNode left, IrPathNode right, Optional<Type> type) implements IrPathNode
{
    public IrArithmeticBinary {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(operator, "operator is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
    }

    @Override
    public <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrArithmeticBinary(this, context);
    }

    public static enum Operator {
        ADD(OperatorType.ADD),
        SUBTRACT(OperatorType.SUBTRACT),
        MULTIPLY(OperatorType.MULTIPLY),
        DIVIDE(OperatorType.DIVIDE),
        MODULUS(OperatorType.MODULUS);

        private final OperatorType type;

        private Operator(OperatorType type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public OperatorType getType() {
            return this.type;
        }
    }
}

