/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import io.opentelemetry.api.trace.Span;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.RemoteTask;
import io.trino.execution.StageId;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.TaskStatus;
import io.trino.execution.scheduler.TaskLifecycleListener;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Optional;

public interface StageExecution {
    public StageId getStageId();

    public int getAttemptId();

    public Span getStageSpan();

    public PlanFragment getFragment();

    public boolean isAnyTaskBlocked();

    public void beginScheduling();

    public void transitionToSchedulingSplits();

    public State getState();

    public void addStateChangeListener(StateMachine.StateChangeListener<State> var1);

    public TaskLifecycleListener getTaskLifecycleListener();

    public void schedulingComplete();

    public void schedulingComplete(PlanNodeId var1);

    public void cancel();

    public void abort();

    public void recordGetSplitTime(long var1);

    public Optional<RemoteTask> scheduleTask(InternalNode var1, int var2, Multimap<PlanNodeId, Split> var3);

    public void failTask(TaskId var1, Throwable var2);

    public List<RemoteTask> getAllTasks();

    public List<TaskStatus> getTaskStatuses();

    public Optional<ExecutionFailureInfo> getFailureCause();

    public static enum State {
        PLANNED(false, false),
        SCHEDULING(false, false),
        SCHEDULING_SPLITS(false, false),
        SCHEDULED(false, false),
        RUNNING(false, false),
        FLUSHING(false, false),
        FINISHED(true, false),
        CANCELED(true, false),
        ABORTED(true, true),
        FAILED(true, true);

        private final boolean doneState;
        private final boolean failureState;

        private State(boolean doneState, boolean failureState) {
            Preconditions.checkArgument((!failureState || doneState ? 1 : 0) != 0, (String)"%s is a non-done failure state", (Object)this.name());
            this.doneState = doneState;
            this.failureState = failureState;
        }

        public boolean isDone() {
            return this.doneState;
        }

        public boolean isFailure() {
            return this.failureState;
        }

        public boolean canScheduleMoreTasks() {
            switch (this) {
                case PLANNED: 
                case SCHEDULING: {
                    return true;
                }
                case SCHEDULING_SPLITS: 
                case SCHEDULED: 
                case RUNNING: 
                case FLUSHING: 
                case FINISHED: 
                case CANCELED: {
                    return false;
                }
                case ABORTED: 
                case FAILED: {
                    return true;
                }
            }
            throw new IllegalStateException("Unhandled state: " + this);
        }
    }
}

