/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import io.airlift.stats.CounterStat;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.TopologyAwareNodeSelectorFactory;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.MBeanExport;
import org.weakref.jmx.MBeanExporter;

public final class NodeSchedulerExporter {
    @GuardedBy(value="this")
    private final List<MBeanExport> mbeanExports = new ArrayList<MBeanExport>();

    @Inject
    public NodeSchedulerExporter(TopologyAwareNodeSelectorFactory nodeSelectorFactory, MBeanExporter exporter) {
        Objects.requireNonNull(nodeSelectorFactory, "nodeSelectorFactory is null");
        Objects.requireNonNull(exporter, "exporter is null");
        for (Map.Entry<String, CounterStat> entry : nodeSelectorFactory.getPlacementCountersByName().entrySet()) {
            try {
                this.mbeanExports.add(exporter.exportWithGeneratedName((Object)entry.getValue(), NodeScheduler.class, (Map)ImmutableMap.of((Object)"segment", (Object)entry.getKey())));
            }
            catch (JmxException jmxException) {}
        }
    }

    @PreDestroy
    public synchronized void destroy() {
        for (MBeanExport mbeanExport : this.mbeanExports) {
            try {
                mbeanExport.unexport();
            }
            catch (JmxException jmxException) {}
        }
        this.mbeanExports.clear();
    }
}

