/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.trino.execution.RemoteTask;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.PartitionIdAllocator;
import io.trino.execution.scheduler.ScheduleResult;
import io.trino.execution.scheduler.SourcePartitionedScheduler;
import io.trino.execution.scheduler.SourceScheduler;
import io.trino.execution.scheduler.SplitPlacementPolicy;
import io.trino.execution.scheduler.SplitPlacementResult;
import io.trino.execution.scheduler.StageExecution;
import io.trino.execution.scheduler.StageScheduler;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.server.DynamicFilterService;
import io.trino.split.SplitSource;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Supplier;

public class FixedSourcePartitionedScheduler
implements StageScheduler {
    private static final Logger log = Logger.get(FixedSourcePartitionedScheduler.class);
    private final StageExecution stageExecution;
    private final List<InternalNode> nodes;
    private final Queue<SourceScheduler> sourceSchedulers;
    private final PartitionIdAllocator partitionIdAllocator;
    private final Map<InternalNode, RemoteTask> scheduledTasks;

    public FixedSourcePartitionedScheduler(StageExecution stageExecution, Map<PlanNodeId, SplitSource> splitSources, List<PlanNodeId> schedulingOrder, List<InternalNode> nodes, BucketNodeMap bucketNodeMap, int splitBatchSize, NodeSelector nodeSelector, DynamicFilterService dynamicFilterService, TableExecuteContextManager tableExecuteContextManager) {
        Objects.requireNonNull(stageExecution, "stageExecution is null");
        Objects.requireNonNull(splitSources, "splitSources is null");
        Objects.requireNonNull(bucketNodeMap, "bucketNodeMap is null");
        Preconditions.checkArgument((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"nodes is empty");
        Objects.requireNonNull(tableExecuteContextManager, "tableExecuteContextManager is null");
        this.stageExecution = stageExecution;
        this.nodes = ImmutableList.copyOf(nodes);
        Preconditions.checkArgument((boolean)splitSources.keySet().equals(ImmutableSet.copyOf(schedulingOrder)));
        BucketedSplitPlacementPolicy splitPlacementPolicy = new BucketedSplitPlacementPolicy(nodeSelector, nodes, bucketNodeMap, stageExecution::getAllTasks);
        ArrayList<SourceScheduler> sourceSchedulers = new ArrayList<SourceScheduler>();
        this.partitionIdAllocator = new PartitionIdAllocator();
        this.scheduledTasks = new HashMap<InternalNode, RemoteTask>();
        for (PlanNodeId planNodeId : schedulingOrder) {
            SplitSource splitSource = splitSources.get(planNodeId);
            SourceScheduler sourceScheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsSourceScheduler(stageExecution, planNodeId, splitSource, splitPlacementPolicy, splitBatchSize, dynamicFilterService, tableExecuteContextManager, () -> true, this.partitionIdAllocator, this.scheduledTasks);
            sourceSchedulers.add(sourceScheduler);
        }
        this.sourceSchedulers = new ArrayDeque<SourceScheduler>(sourceSchedulers);
    }

    @Override
    public ScheduleResult schedule() {
        ImmutableList newTasks = ImmutableList.of();
        if (this.scheduledTasks.isEmpty()) {
            ImmutableList.Builder newTasksBuilder = ImmutableList.builder();
            for (InternalNode node : this.nodes) {
                Optional<RemoteTask> task = this.stageExecution.scheduleTask(node, this.partitionIdAllocator.getNextId(), (Multimap<PlanNodeId, Split>)ImmutableMultimap.of());
                if (!task.isPresent()) continue;
                this.scheduledTasks.put(node, task.get());
                newTasksBuilder.add((Object)task.get());
            }
            newTasks = newTasksBuilder.build();
        }
        ListenableFuture<Void> blocked = Futures.immediateFuture(null);
        ScheduleResult.BlockedReason blockedReason = null;
        int splitsScheduled = 0;
        while (!this.sourceSchedulers.isEmpty()) {
            SourceScheduler scheduler = this.sourceSchedulers.peek();
            ScheduleResult schedule = scheduler.schedule();
            splitsScheduled += schedule.getSplitsScheduled();
            blocked = schedule.getBlocked();
            blockedReason = schedule.getBlockedReason().isPresent() ? schedule.getBlockedReason().get() : null;
            if (!blocked.isDone() || !schedule.isFinished()) break;
            this.stageExecution.schedulingComplete(scheduler.getPlanNodeId());
            this.sourceSchedulers.remove().close();
        }
        if (blockedReason != null) {
            return new ScheduleResult(this.sourceSchedulers.isEmpty(), (Iterable<? extends RemoteTask>)newTasks, blocked, blockedReason, splitsScheduled);
        }
        Preconditions.checkState((boolean)blocked.isDone(), (Object)"blockedReason not provided when scheduler is blocked");
        return new ScheduleResult(this.sourceSchedulers.isEmpty(), (Iterable<? extends RemoteTask>)newTasks, splitsScheduled);
    }

    @Override
    public void close() {
        for (SourceScheduler sourceScheduler : this.sourceSchedulers) {
            try {
                sourceScheduler.close();
            }
            catch (Throwable t) {
                log.warn(t, "Error closing split source");
            }
        }
        this.sourceSchedulers.clear();
    }

    public static class BucketedSplitPlacementPolicy
    implements SplitPlacementPolicy {
        private final NodeSelector nodeSelector;
        private final List<InternalNode> allNodes;
        private final BucketNodeMap bucketNodeMap;
        private final Supplier<? extends List<RemoteTask>> remoteTasks;

        public BucketedSplitPlacementPolicy(NodeSelector nodeSelector, List<InternalNode> allNodes, BucketNodeMap bucketNodeMap, Supplier<? extends List<RemoteTask>> remoteTasks) {
            this.nodeSelector = Objects.requireNonNull(nodeSelector, "nodeSelector is null");
            this.allNodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(allNodes, "allNodes is null"));
            this.bucketNodeMap = Objects.requireNonNull(bucketNodeMap, "bucketNodeMap is null");
            this.remoteTasks = Objects.requireNonNull(remoteTasks, "remoteTasks is null");
        }

        @Override
        public SplitPlacementResult computeAssignments(Set<Split> splits) {
            return this.nodeSelector.computeAssignments(splits, this.remoteTasks.get(), this.bucketNodeMap);
        }

        @Override
        public void lockDownNodes() {
        }

        @Override
        public List<InternalNode> allNodes() {
            return this.allNodes;
        }
    }
}

