/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.spi.exchange.ExchangeSourceHandleSource;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class Exchanges {
    private Exchanges() {
    }

    public static ListenableFuture<List<ExchangeSourceHandle>> getAllSourceHandles(final ExchangeSourceHandleSource handleSource) {
        return new AbstractFuture<List<ExchangeSourceHandle>>(){
            private final ImmutableList.Builder<ExchangeSourceHandle> handles = ImmutableList.builder();
            private CompletableFuture<ExchangeSourceHandleSource.ExchangeSourceHandleBatch> nextBatchFuture;

            private synchronized AbstractFuture<List<ExchangeSourceHandle>> process() {
                if (this.isDone()) {
                    return this;
                }
                try {
                    Preconditions.checkState((this.nextBatchFuture == null || this.nextBatchFuture.isDone() ? 1 : 0) != 0, (Object)"nextBatchFuture is expected to be done");
                    this.nextBatchFuture = handleSource.getNextBatch();
                    this.nextBatchFuture.whenComplete((result, failure) -> {
                        if (failure != null) {
                            this.setException((Throwable)failure);
                            handleSource.close();
                            return;
                        }
                        this.handles.addAll((Iterable)result.handles());
                        if (result.lastBatch()) {
                            this.set(this.handles.build());
                            handleSource.close();
                            return;
                        }
                        this.process();
                    });
                }
                catch (Throwable t) {
                    this.setException(t);
                    handleSource.close();
                }
                return this;
            }

            protected synchronized void interruptTask() {
                if (this.nextBatchFuture != null) {
                    this.nextBatchFuture.cancel(true);
                    this.nextBatchFuture = null;
                }
                handleSource.close();
            }
        }.process();
    }
}

