/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.querystats;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.ThreadSafe;
import io.trino.execution.querystats.QueryPlanOptimizerStats;
import io.trino.spi.eventlistener.QueryPlanOptimizerStatistics;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@ThreadSafe
public class PlanOptimizersStatsCollector {
    private final Map<Class<?>, QueryPlanOptimizerStats> stats = new ConcurrentHashMap();
    private final int queryReportedRuleStatsLimit;

    public PlanOptimizersStatsCollector(int queryReportedRuleStatsLimit) {
        this.queryReportedRuleStatsLimit = queryReportedRuleStatsLimit;
    }

    public void recordRule(Rule<?> rule, boolean invoked, boolean applied, long elapsedNanos) {
        if (invoked) {
            this.statsForClass(rule.getClass()).record(elapsedNanos, applied);
        }
    }

    public void recordOptimizer(PlanOptimizer planOptimizer, long duration) {
        this.statsForClass(planOptimizer.getClass()).record(duration, true);
    }

    public void recordFailure(Rule<?> rule) {
        this.statsForClass(rule.getClass()).recordFailure();
    }

    public void recordFailure(PlanOptimizer rule) {
        this.statsForClass(rule.getClass()).recordFailure();
    }

    public List<QueryPlanOptimizerStatistics> getTopRuleStats() {
        return this.getTopRuleStats(this.queryReportedRuleStatsLimit);
    }

    public List<QueryPlanOptimizerStatistics> getTopRuleStats(int limit) {
        return (List)this.stats.values().stream().map(QueryPlanOptimizerStats::snapshot).sorted(Comparator.comparing(QueryPlanOptimizerStatistics::totalTime).reversed()).limit(limit).collect(ImmutableList.toImmutableList());
    }

    public void add(PlanOptimizersStatsCollector other) {
        other.stats.forEach((key, value) -> this.statsForClass((Class<?>)key).merge((QueryPlanOptimizerStats)value));
    }

    private QueryPlanOptimizerStats statsForClass(Class<?> clazz) {
        return this.stats.computeIfAbsent(clazz, key -> new QueryPlanOptimizerStats(key.getCanonicalName()));
    }

    public static PlanOptimizersStatsCollector createPlanOptimizersStatsCollector() {
        return new PlanOptimizersStatsCollector(Integer.MAX_VALUE);
    }
}

