/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.buffer.BufferState;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public class OutputBufferStateMachine {
    private final StateMachine<BufferState> state;
    private final AtomicReference<Throwable> failureCause = new AtomicReference();

    public OutputBufferStateMachine(TaskId taskId, Executor executor) {
        this.state = new StateMachine<BufferState>(taskId + "-buffer", executor, BufferState.OPEN, BufferState.TERMINAL_BUFFER_STATES);
    }

    public BufferState getState() {
        return this.state.get();
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.state.addStateChangeListener(stateChangeListener);
    }

    public boolean noMoreBuffers() {
        if (this.state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_BUFFERS)) {
            return true;
        }
        return this.state.compareAndSet(BufferState.NO_MORE_PAGES, BufferState.FLUSHING);
    }

    public boolean noMorePages() {
        if (this.state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_PAGES)) {
            return true;
        }
        return this.state.compareAndSet(BufferState.NO_MORE_BUFFERS, BufferState.FLUSHING);
    }

    public boolean finish() {
        return this.state.setIf(BufferState.FINISHED, oldState -> !oldState.isTerminal());
    }

    public boolean abort() {
        return this.state.setIf(BufferState.ABORTED, oldState -> !oldState.isTerminal());
    }

    public boolean fail(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        this.failureCause.compareAndSet(null, throwable);
        return this.state.setIf(BufferState.FAILED, oldState -> !oldState.isTerminal());
    }

    public Optional<Throwable> getFailureCause() {
        return Optional.ofNullable(this.failureCause.get());
    }
}

