/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetColumnType;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class SetColumnTypeTask
implements DataDefinitionTask<SetColumnType> {
    private final Metadata metadata;
    private final TypeManager typeManager;
    private final AccessControl accessControl;

    @Inject
    public SetColumnTypeTask(Metadata metadata, TypeManager typeManager, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "SET COLUMN TYPE";
    }

    @Override
    public ListenableFuture<Void> execute(SetColumnType statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName qualifiedObjectName;
        Session session = stateMachine.getSession();
        RedirectionAwareTableHandle redirectionAwareTableHandle = this.metadata.getRedirectionAwareTableHandle(session, qualifiedObjectName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTableName()));
        if (redirectionAwareTableHandle.tableHandle().isEmpty()) {
            Object exceptionMessage = String.format("Table '%s' does not exist", qualifiedObjectName);
            if (this.metadata.getMaterializedView(session, qualifiedObjectName).isPresent()) {
                exceptionMessage = (String)exceptionMessage + ", but a materialized view with that name exists.";
            } else if (this.metadata.getView(session, qualifiedObjectName).isPresent()) {
                exceptionMessage = (String)exceptionMessage + ", but a view with that name exists.";
            }
            if (!statement.isTableExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, (String)exceptionMessage, new Object[0]);
            }
            return Futures.immediateVoidFuture();
        }
        this.accessControl.checkCanAlterColumn(session.toSecurityContext(), redirectionAwareTableHandle.redirectedTableName().orElse(qualifiedObjectName));
        TableHandle tableHandle = redirectionAwareTableHandle.tableHandle().get();
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(session, tableHandle);
        String columnName = ((String)statement.getColumnName().getParts().get(0)).toLowerCase(Locale.ENGLISH);
        ColumnHandle column = columnHandles.get(columnName);
        if (column == null) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column '%s' does not exist", statement.getColumnName());
        }
        Type type = this.getColumnType(statement);
        if (statement.getColumnName().getParts().size() == 1) {
            this.metadata.setColumnType(session, tableHandle, column, type);
        } else {
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(session, tableHandle, column);
            List fieldPath = statement.getColumnName().getParts();
            Type currentType = columnMetadata.getType();
            for (int i = 1; i < fieldPath.size(); ++i) {
                String fieldName = (String)fieldPath.get(i);
                List<RowType.Field> candidates = SetColumnTypeTask.getCandidates(currentType, fieldName);
                if (candidates.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Field '%s' does not exist within %s", fieldName, currentType);
                }
                if (candidates.size() > 1) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME, (Node)statement, "Field path %s within %s is ambiguous", fieldPath, columnMetadata.getType());
                }
                currentType = ((RowType.Field)Iterables.getOnlyElement(candidates)).getType();
            }
            Preconditions.checkState((fieldPath.size() >= 2 ? 1 : 0) != 0, (String)"fieldPath size must be >= 2: %s", (Object)fieldPath);
            this.metadata.setFieldType(session, tableHandle, fieldPath, type);
        }
        return Futures.immediateVoidFuture();
    }

    private static List<RowType.Field> getCandidates(Type type, String fieldName) {
        if (!(type instanceof RowType)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + type);
        }
        RowType rowType = (RowType)type;
        List candidates = (List)rowType.getFields().stream().filter(rowField -> rowField.getName().isPresent() && ((String)rowField.getName().get()).equalsIgnoreCase(fieldName)).collect(ImmutableList.toImmutableList());
        return candidates;
    }

    private Type getColumnType(SetColumnType statement) {
        Type type;
        try {
            type = this.typeManager.getType(TypeSignatureTranslator.toTypeSignature(statement.getType()));
        }
        catch (TypeNotFoundException e) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)statement.getType(), "Unknown type '%s' for column '%s'", statement.getType(), statement.getColumnName());
        }
        if (type.equals((Object)UnknownType.UNKNOWN)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)statement.getType(), "Unknown type '%s' for column '%s'", statement.getType(), statement.getColumnName());
        }
        return type;
    }
}

