/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.sql.tree.DefaultTraversalVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ParameterExtractor {
    private ParameterExtractor() {
    }

    public static int getParameterCount(Statement statement) {
        return ParameterExtractor.extractParameters(statement).size();
    }

    public static List<Parameter> extractParameters(Statement statement) {
        ParameterExtractingVisitor parameterExtractingVisitor = new ParameterExtractingVisitor();
        parameterExtractingVisitor.process((Node)statement, null);
        return (List)parameterExtractingVisitor.getParameters().stream().sorted(Comparator.comparing(parameter -> (NodeLocation)parameter.getLocation().get(), Comparator.comparing(NodeLocation::getLineNumber).thenComparing(NodeLocation::getColumnNumber))).collect(ImmutableList.toImmutableList());
    }

    public static Map<NodeRef<Parameter>, Expression> bindParameters(Statement statement, List<Expression> values) {
        List<Parameter> parametersList = ParameterExtractor.extractParameters(statement);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterator<Expression> iterator = values.iterator();
        for (Parameter parameter : parametersList) {
            builder.put((Object)NodeRef.of((Node)parameter), (Object)iterator.next());
        }
        return builder.buildOrThrow();
    }

    private static class ParameterExtractingVisitor
    extends DefaultTraversalVisitor<Void> {
        private final List<Parameter> parameters = new ArrayList<Parameter>();

        private ParameterExtractingVisitor() {
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public Void visitParameter(Parameter node, Void context) {
            this.parameters.add(node);
            return null;
        }
    }
}

