/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.connector.ConnectorName;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.PropertyUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.CreateCatalog;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class CreateCatalogTask
implements DataDefinitionTask<CreateCatalog> {
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final CatalogManager catalogManager;

    @Inject
    public CreateCatalogTask(PlannerContext plannerContext, AccessControl accessControl, CatalogManager catalogManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.catalogManager = Objects.requireNonNull(catalogManager, "catalogManager is null");
    }

    @Override
    public String getName() {
        return "CREATE CATALOG";
    }

    @Override
    public ListenableFuture<Void> execute(CreateCatalog statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        if (statement.getPrincipal().isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE CATALOG with AUTHORIZATION is not yet supported");
        }
        Session session = stateMachine.getSession();
        String catalog = statement.getCatalogName().toString();
        this.accessControl.checkCanCreateCatalog(session.toSecurityContext(), catalog);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Property property : statement.getProperties()) {
            if (property.isSetToDefault()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_CATALOG_PROPERTY, (Node)property, "Catalog properties do not support DEFAULT value", new Object[0]);
            }
            properties.put(property.getName().getValue(), (String)PropertyUtil.evaluateProperty(property.getName().getValue(), (Type)VarcharType.VARCHAR, property.getNonDefaultValue(), session, this.plannerContext, this.accessControl, ParameterExtractor.bindParameters((Statement)statement, parameters), (ErrorCodeSupplier)StandardErrorCode.INVALID_CATALOG_PROPERTY, "catalog property"));
        }
        ConnectorName connectorName = new ConnectorName(statement.getConnectorName().toString());
        this.catalogManager.createCatalog(catalog, connectorName, properties, statement.isNotExists());
        return Futures.immediateVoidFuture();
    }
}

