/*
 * Decompiled with CFR 0.152.
 */
package io.trino.dispatcher;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.log.Logger;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.dispatcher.DispatchExecutor;
import io.trino.dispatcher.DispatchQuery;
import io.trino.dispatcher.DispatchQueryFactory;
import io.trino.dispatcher.LocalDispatchQuery;
import io.trino.event.QueryMonitor;
import io.trino.execution.ClusterSizeMonitor;
import io.trino.execution.LocationFactory;
import io.trino.execution.QueryExecution;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.QueryPreparer;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.execution.warnings.WarningCollectorFactory;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.server.protocol.Slug;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.tree.Statement;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import io.trino.util.StatementUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;

public class LocalDispatchQueryFactory
implements DispatchQueryFactory {
    private static final Logger log = Logger.get(LocalDispatchQueryFactory.class);
    private final QueryManager queryManager;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final Metadata metadata;
    private final QueryMonitor queryMonitor;
    private final LocationFactory locationFactory;
    private final ClusterSizeMonitor clusterSizeMonitor;
    private final Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories;
    private final WarningCollectorFactory warningCollectorFactory;
    private final ListeningExecutorService executor;
    private final int maxStateMachineThreadsPerQuery;
    private final int queryReportedRuleStatsLimit;
    private final boolean faultTolerantExecutionExchangeEncryptionEnabled;
    private final NodeVersion version;

    @Inject
    public LocalDispatchQueryFactory(QueryManager queryManager, QueryManagerConfig queryManagerConfig, TransactionManager transactionManager, AccessControl accessControl, Metadata metadata, QueryMonitor queryMonitor, LocationFactory locationFactory, Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories, WarningCollectorFactory warningCollectorFactory, ClusterSizeMonitor clusterSizeMonitor, DispatchExecutor dispatchExecutor, FeaturesConfig featuresConfig, NodeVersion version) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.executionFactories = Objects.requireNonNull(executionFactories, "executionFactories is null");
        this.warningCollectorFactory = Objects.requireNonNull(warningCollectorFactory, "warningCollectorFactory is null");
        this.clusterSizeMonitor = Objects.requireNonNull(clusterSizeMonitor, "clusterSizeMonitor is null");
        this.executor = dispatchExecutor.getExecutor();
        this.maxStateMachineThreadsPerQuery = queryManagerConfig.getMaxStateMachineCallbackThreads();
        this.queryReportedRuleStatsLimit = queryManagerConfig.getQueryReportedRuleStatsLimit();
        this.faultTolerantExecutionExchangeEncryptionEnabled = Objects.requireNonNull(featuresConfig, "featuresConfig is null").isFaultTolerantExecutionExchangeEncryptionEnabled();
        this.version = Objects.requireNonNull(version, "version is null");
    }

    @Override
    public DispatchQuery createDispatchQuery(Session session, Optional<TransactionId> existingTransactionId, String query, QueryPreparer.PreparedQuery preparedQuery, Slug slug, ResourceGroupId resourceGroup) {
        WarningCollector warningCollector = this.warningCollectorFactory.create();
        PlanOptimizersStatsCollector planOptimizersStatsCollector = new PlanOptimizersStatsCollector(this.queryReportedRuleStatsLimit);
        QueryStateMachine stateMachine = QueryStateMachine.begin(existingTransactionId, query, preparedQuery.getPrepareSql(), session, this.locationFactory.createQueryLocation(session.getQueryId()), resourceGroup, StatementUtils.isTransactionControlStatement(preparedQuery.getStatement()), this.transactionManager, this.accessControl, (Executor)new BoundedExecutor((Executor)this.executor, this.maxStateMachineThreadsPerQuery), this.metadata, warningCollector, planOptimizersStatsCollector, StatementUtils.getQueryType(preparedQuery.getStatement()), this.faultTolerantExecutionExchangeEncryptionEnabled, this.version);
        this.queryMonitor.queryCreatedEvent(stateMachine.getBasicQueryInfo(Optional.empty()));
        ListenableFuture queryExecutionFuture = this.executor.submit(() -> {
            QueryExecution.QueryExecutionFactory<?> queryExecutionFactory = this.executionFactories.get(preparedQuery.getStatement().getClass());
            if (queryExecutionFactory == null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type: " + preparedQuery.getStatement().getClass().getSimpleName());
            }
            try {
                return queryExecutionFactory.createQueryExecution(preparedQuery, stateMachine, slug, warningCollector, planOptimizersStatsCollector);
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    if (e instanceof StackOverflowError) {
                        log.error(e, "Unhandled StackOverFlowError; should be handled earlier; to investigate full stacktrace you may need to enable -XX:MaxJavaStackTraceDepth=0 JVM flag");
                    } else {
                        log.error(e, "Unhandled Error");
                    }
                    RuntimeException wrappedError = new RuntimeException(e);
                    stateMachine.transitionToFailed(wrappedError);
                    throw wrappedError;
                }
                stateMachine.transitionToFailed(e);
                throw e;
            }
        });
        return new LocalDispatchQuery(stateMachine, (ListenableFuture<QueryExecution>)queryExecutionFuture, this.queryMonitor, this.clusterSizeMonitor, (Executor)this.executor, this.queryManager::createQuery);
    }
}

