/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.cost.ComposableStatsCalculator;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsProvider;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.cost.TableStatsProvider;
import io.trino.matching.Pattern;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.block.Block;
import io.trino.spi.block.SingleRowBlock;
import io.trino.spi.statistics.StatsUtil;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;

public class ValuesStatsRule
implements ComposableStatsCalculator.Rule<ValuesNode> {
    private static final Pattern<ValuesNode> PATTERN = Patterns.values();
    private final PlannerContext plannerContext;

    public ValuesStatsRule(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<ValuesNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Optional<PlanNodeStatsEstimate> calculate(ValuesNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types, TableStatsProvider tableStatsProvider) {
        PlanNodeStatsEstimate.Builder statsBuilder = PlanNodeStatsEstimate.builder();
        statsBuilder.setOutputRowCount(node.getRowCount());
        for (int symbolId = 0; symbolId < node.getOutputSymbols().size(); ++symbolId) {
            Symbol symbol = node.getOutputSymbols().get(symbolId);
            List<Object> symbolValues = this.getSymbolValues(node, symbolId, session, (Type)RowType.anonymous((List)((List)node.getOutputSymbols().stream().map(types::get).collect(ImmutableList.toImmutableList()))));
            statsBuilder.addSymbolStatistics(symbol, this.buildSymbolStatistics(symbolValues, types.get(symbol)));
        }
        return Optional.of(statsBuilder.build());
    }

    private List<Object> getSymbolValues(ValuesNode valuesNode, int symbolId, Session session, Type rowType) {
        Type symbolType = (Type)rowType.getTypeParameters().get(symbolId);
        if (UnknownType.UNKNOWN.equals(symbolType)) {
            return IntStream.range(0, valuesNode.getRowCount()).mapToObj(rowId -> null).collect(Collectors.toList());
        }
        Preconditions.checkState((boolean)valuesNode.getRows().isPresent(), (Object)"rows is empty");
        return valuesNode.getRows().get().stream().map(row -> {
            Object rowValue = ExpressionInterpreter.evaluateConstantExpression(row, rowType, this.plannerContext, session, new AllowAllAccessControl(), (Map<NodeRef<Parameter>, Expression>)ImmutableMap.of());
            return TypeUtils.readNativeValue((Type)symbolType, (Block)((SingleRowBlock)rowValue), (int)symbolId);
        }).collect(Collectors.toList());
    }

    private SymbolStatsEstimate buildSymbolStatistics(List<Object> values, Type type) {
        List nonNullValues = (List)values.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        if (nonNullValues.isEmpty()) {
            return SymbolStatsEstimate.zero();
        }
        double[] valuesAsDoubles = nonNullValues.stream().map(value -> StatsUtil.toStatsRepresentation((Type)type, (Object)value)).filter(OptionalDouble::isPresent).mapToDouble(OptionalDouble::getAsDouble).toArray();
        double lowValue = DoubleStream.of(valuesAsDoubles).min().orElse(Double.NEGATIVE_INFINITY);
        double highValue = DoubleStream.of(valuesAsDoubles).max().orElse(Double.POSITIVE_INFINITY);
        double valuesCount = values.size();
        double nonNullValuesCount = nonNullValues.size();
        long distinctValuesCount = nonNullValues.stream().distinct().count();
        return SymbolStatsEstimate.builder().setNullsFraction((valuesCount - nonNullValuesCount) / valuesCount).setLowValue(lowValue).setHighValue(highValue).setDistinctValuesCount(distinctValuesCount).build();
    }
}

