/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.collect.ImmutableList;
import io.trino.connector.CatalogProperties;
import io.trino.connector.CatalogStore;
import io.trino.connector.ConnectorName;
import io.trino.connector.FileCatalogStore;
import io.trino.spi.connector.CatalogHandle;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InMemoryCatalogStore
implements CatalogStore {
    private final ConcurrentMap<String, CatalogStore.StoredCatalog> catalogs = new ConcurrentHashMap<String, CatalogStore.StoredCatalog>();

    @Override
    public Collection<CatalogStore.StoredCatalog> getCatalogs() {
        return ImmutableList.copyOf(this.catalogs.values());
    }

    @Override
    public CatalogProperties createCatalogProperties(String catalogName, ConnectorName connectorName, Map<String, String> properties) {
        return new CatalogProperties(CatalogHandle.createRootCatalogHandle((String)catalogName, (CatalogHandle.CatalogVersion)FileCatalogStore.computeCatalogVersion(catalogName, connectorName, properties)), connectorName, properties);
    }

    @Override
    public void addOrReplaceCatalog(CatalogProperties catalogProperties) {
        this.catalogs.put(catalogProperties.getCatalogHandle().getCatalogName(), new InMemoryStoredCatalog(catalogProperties));
    }

    @Override
    public void removeCatalog(String catalogName) {
        this.catalogs.remove(catalogName);
    }

    private static class InMemoryStoredCatalog
    implements CatalogStore.StoredCatalog {
        private final CatalogProperties catalogProperties;

        public InMemoryStoredCatalog(CatalogProperties catalogProperties) {
            this.catalogProperties = Objects.requireNonNull(catalogProperties, "catalogProperties is null");
        }

        @Override
        public String getName() {
            return this.catalogProperties.getCatalogHandle().getCatalogName();
        }

        @Override
        public CatalogProperties loadProperties() {
            return this.catalogProperties;
        }
    }
}

