/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Preconditions;
import io.trino.spi.connector.CatalogHandle;
import jakarta.validation.constraints.NotNull;

public interface CatalogServiceProvider<T> {
    public static <T> CatalogServiceProvider<T> fail() {
        return CatalogServiceProvider.fail("Not supported");
    }

    public static <T> CatalogServiceProvider<T> fail(String message) {
        return catalogName -> {
            throw new IllegalStateException(message);
        };
    }

    public static <T> CatalogServiceProvider<T> singleton(CatalogHandle catalogHandle, T value) {
        return handle -> {
            Preconditions.checkArgument((boolean)handle.equals((Object)catalogHandle));
            return value;
        };
    }

    @NotNull
    public T getService(CatalogHandle var1);
}

