/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.file;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.util.Set;

public class FileTableDescriptionSupplierConfig {
    private Set<String> tableNames = ImmutableSet.of();
    private File tableDescriptionDir = new File("etc/kafka/");

    @NotNull
    public Set<String> getTableNames() {
        return this.tableNames;
    }

    @Config(value="kafka.table-names")
    @ConfigDescription(value="Set of tables known to this connector")
    public FileTableDescriptionSupplierConfig setTableNames(String tableNames) {
        this.tableNames = ImmutableSet.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)tableNames));
        return this;
    }

    @NotNull
    public File getTableDescriptionDir() {
        return this.tableDescriptionDir;
    }

    @Config(value="kafka.table-description-dir")
    @ConfigDescription(value="Folder holding JSON description files for Kafka topics")
    public FileTableDescriptionSupplierConfig setTableDescriptionDir(File tableDescriptionDir) {
        this.tableDescriptionDir = tableDescriptionDir;
        return this;
    }
}

