/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.kafka.schema.confluent.AvroSchemaConverter;
import io.trino.plugin.kafka.schema.confluent.ConfluentSchemaRegistryConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;

public class ConfluentSessionProperties
implements SessionPropertiesProvider {
    public static final String EMPTY_FIELD_STRATEGY = "empty_field_strategy";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public ConfluentSessionProperties(ConfluentSchemaRegistryConfig config) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadata.enumProperty((String)EMPTY_FIELD_STRATEGY, (String)"Strategy for handling struct types with no fields: IGNORE (default), FAIL, and MARK to add a boolean field named '$empty_field_marker'", AvroSchemaConverter.EmptyFieldStrategy.class, (Enum)config.getEmptyFieldStrategy(), (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static AvroSchemaConverter.EmptyFieldStrategy getEmptyFieldStrategy(ConnectorSession session) {
        return (AvroSchemaConverter.EmptyFieldStrategy)((Object)session.getProperty(EMPTY_FIELD_STRATEGY, AvroSchemaConverter.EmptyFieldStrategy.class));
    }
}

