/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.inject.Inject;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import io.airlift.slice.Slices;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.MessageIndexes;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.trino.cache.NonEvictableLoadingCache;
import io.trino.cache.SafeCaches;
import io.trino.decoder.protobuf.DynamicMessageProvider;
import io.trino.decoder.protobuf.ProtobufErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;

public class ConfluentSchemaRegistryDynamicMessageProvider
implements DynamicMessageProvider {
    private static final int MAGIC_BYTE = 0;
    private final SchemaRegistryClient schemaRegistryClient;
    private final NonEvictableLoadingCache<Integer, Descriptors.Descriptor> descriptorCache;

    public ConfluentSchemaRegistryDynamicMessageProvider(SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient, "schemaRegistryClient is null");
        this.descriptorCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L), (CacheLoader)CacheLoader.from(this::lookupDescriptor));
    }

    public DynamicMessage parseDynamicMessage(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        byte magicByte = buffer.get();
        Preconditions.checkArgument((magicByte == 0 ? 1 : 0) != 0, (Object)"Invalid MagicByte");
        int schemaId = buffer.getInt();
        MessageIndexes.readFrom((ByteBuffer)buffer);
        try {
            return DynamicMessage.parseFrom((Descriptors.Descriptor)((Descriptors.Descriptor)this.descriptorCache.getUnchecked((Object)schemaId)), (InputStream)Slices.wrappedBuffer((ByteBuffer)buffer).getInput());
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)ProtobufErrorCode.INVALID_PROTOBUF_MESSAGE, "Decoding Protobuf record failed.", (Throwable)e);
        }
    }

    private Descriptors.Descriptor lookupDescriptor(int schemaId) {
        try {
            ParsedSchema schema = this.schemaRegistryClient.getSchemaById(schemaId);
            Preconditions.checkArgument((boolean)(schema instanceof ProtobufSchema), (Object)"schema should be an instance of ProtobufSchema");
            return ((ProtobufSchema)schema).toDescriptor();
        }
        catch (RestClientException | IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Looking up schemaId '%s'from confluent schema registry failed", schemaId), e);
        }
    }

    public static class Factory
    implements DynamicMessageProvider.Factory {
        private final SchemaRegistryClient schemaRegistryClient;

        @Inject
        public Factory(SchemaRegistryClient schemaRegistryClient) {
            this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient, "schemaRegistryClient is null");
        }

        public DynamicMessageProvider create(Optional<String> protoFile) {
            return new ConfluentSchemaRegistryDynamicMessageProvider(this.schemaRegistryClient);
        }
    }
}

