/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.protobuf.Descriptors;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.trino.cache.SafeCaches;
import io.trino.decoder.protobuf.DescriptorProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class ConfluentDescriptorProvider
implements DescriptorProvider {
    private final LoadingCache<String, Descriptors.Descriptor> protobufTypeUrlCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L), (CacheLoader)CacheLoader.from(this::loadDescriptorFromType));

    public Optional<Descriptors.Descriptor> getDescriptorFromTypeUrl(String url) {
        try {
            Objects.requireNonNull(url, "url is null");
            return Optional.of((Descriptors.Descriptor)this.protobufTypeUrlCache.get((Object)url));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Descriptors.Descriptor loadDescriptorFromType(String url) {
        try {
            return ((ProtobufSchema)new ProtobufSchemaProvider().parseSchema(this.getContents(url), List.of(), true).orElseThrow()).toDescriptor();
        }
        catch (NoSuchElementException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Failed to parse protobuf schema");
        }
    }
}

