/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.avro.Schema;

public class ClassLoaderSafeSchemaRegistryClient
implements SchemaRegistryClient {
    private final SchemaRegistryClient delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeSchemaRegistryClient(SchemaRegistryClient delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.parseSchema(schemaType, schemaString, references);
            return optional;
        }
    }

    public int register(String subject, Schema schema) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            int n = this.delegate.register(subject, schema);
            return n;
        }
    }

    public int register(String subject, ParsedSchema parsedSchema) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            int n = this.delegate.register(subject, parsedSchema);
            return n;
        }
    }

    public int register(String subject, Schema schema, int version, int id) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            int n = this.delegate.register(subject, schema, version, id);
            return n;
        }
    }

    public int register(String subject, ParsedSchema parsedSchema, int version, int id) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            int n = this.delegate.register(subject, parsedSchema, version, id);
            return n;
        }
    }

    public int register(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            int n = this.delegate.register(subject, schema, normalize);
            return n;
        }
    }

    public Schema getByID(int id) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Schema schema = this.delegate.getByID(id);
            return schema;
        }
    }

    public Schema getById(int id) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Schema schema = this.delegate.getById(id);
            return schema;
        }
    }

    public int getId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            int n = this.delegate.getId(subject, schema, normalize);
            return n;
        }
    }

    public Optional<ParsedSchema> parseSchema(io.confluent.kafka.schemaregistry.client.rest.entities.Schema schema) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.parseSchema(schema);
            return optional;
        }
    }

    public List<ParsedSchema> getSchemas(String subjectPrefix, boolean lookupDeletedSchema, boolean latestOnly) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.getSchemas(subjectPrefix, lookupDeletedSchema, latestOnly);
            return list;
        }
    }

    public SchemaMetadata getSchemaMetadata(String subject, int version, boolean lookupDeletedSchema) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            SchemaMetadata schemaMetadata = this.delegate.getSchemaMetadata(subject, version, lookupDeletedSchema);
            return schemaMetadata;
        }
    }

    public int getVersion(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            int n = this.delegate.getVersion(subject, schema, normalize);
            return n;
        }
    }

    public List<Integer> getAllVersions(String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.getAllVersions(subject, lookupDeletedSchema);
            return list;
        }
    }

    public List<String> testCompatibilityVerbose(String subject, ParsedSchema schema) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.testCompatibilityVerbose(subject, schema);
            return list;
        }
    }

    public void deleteCompatibility(String subject) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.deleteCompatibility(subject);
        }
    }

    public void deleteMode(String subject) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.deleteMode(subject);
        }
    }

    public Collection<String> getAllSubjects(boolean lookupDeletedSubject) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Collection collection = this.delegate.getAllSubjects(lookupDeletedSubject);
            return collection;
        }
    }

    public Collection<String> getAllSubjectsByPrefix(String subjectPrefix) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Collection collection = this.delegate.getAllSubjectsByPrefix(subjectPrefix);
            return collection;
        }
    }

    public List<Integer> deleteSubject(String subject, boolean isPermanent) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.deleteSubject(subject, isPermanent);
            return list;
        }
    }

    public List<Integer> deleteSubject(Map<String, String> requestProperties, String subject, boolean isPermanent) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.deleteSubject(requestProperties, subject, isPermanent);
            return list;
        }
    }

    public Integer deleteSchemaVersion(String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Integer n = this.delegate.deleteSchemaVersion(subject, version, isPermanent);
            return n;
        }
    }

    public Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Integer n = this.delegate.deleteSchemaVersion(requestProperties, subject, version, isPermanent);
            return n;
        }
    }

    public ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ParsedSchema parsedSchema = this.delegate.getSchemaById(id);
            return parsedSchema;
        }
    }

    public Schema getBySubjectAndID(String subject, int id) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Schema schema = this.delegate.getBySubjectAndID(subject, id);
            return schema;
        }
    }

    public Schema getBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Schema schema = this.delegate.getBySubjectAndId(subject, id);
            return schema;
        }
    }

    public ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ParsedSchema parsedSchema = this.delegate.getSchemaBySubjectAndId(subject, id);
            return parsedSchema;
        }
    }

    public Collection<String> getAllSubjectsById(int id) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Collection collection = this.delegate.getAllSubjectsById(id);
            return collection;
        }
    }

    public Collection<SubjectVersion> getAllVersionsById(int id) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Collection collection = this.delegate.getAllVersionsById(id);
            return collection;
        }
    }

    public io.confluent.kafka.schemaregistry.client.rest.entities.Schema getByVersion(String subject, int version, boolean lookupDeletedSchema) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            io.confluent.kafka.schemaregistry.client.rest.entities.Schema schema = this.delegate.getByVersion(subject, version, lookupDeletedSchema);
            return schema;
        }
    }

    public SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            SchemaMetadata schemaMetadata = this.delegate.getLatestSchemaMetadata(subject);
            return schemaMetadata;
        }
    }

    public SchemaMetadata getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            SchemaMetadata schemaMetadata = this.delegate.getSchemaMetadata(subject, version);
            return schemaMetadata;
        }
    }

    public int getVersion(String subject, Schema schema) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            int n = this.delegate.getVersion(subject, schema);
            return n;
        }
    }

    public int getVersion(String subject, ParsedSchema parsedSchema) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            int n = this.delegate.getVersion(subject, parsedSchema);
            return n;
        }
    }

    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.getAllVersions(subject);
            return list;
        }
    }

    public boolean testCompatibility(String subject, Schema schema) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.testCompatibility(subject, schema);
            return bl;
        }
    }

    public boolean testCompatibility(String subject, ParsedSchema parsedSchema) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.testCompatibility(subject, parsedSchema);
            return bl;
        }
    }

    public String updateCompatibility(String subject, String compatibility) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.updateCompatibility(subject, compatibility);
            return string;
        }
    }

    public String getCompatibility(String subject) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.getCompatibility(subject);
            return string;
        }
    }

    public String setMode(String mode) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.setMode(mode);
            return string;
        }
    }

    public String setMode(String mode, String subject) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.setMode(mode, subject);
            return string;
        }
    }

    public String getMode() throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.getMode();
            return string;
        }
    }

    public String getMode(String subject) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.getMode(subject);
            return string;
        }
    }

    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Collection collection = this.delegate.getAllSubjects();
            return collection;
        }
    }

    public int getId(String subject, Schema schema) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            int n = this.delegate.getId(subject, schema);
            return n;
        }
    }

    public int getId(String subject, ParsedSchema parsedSchema) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            int n = this.delegate.getId(subject, parsedSchema);
            return n;
        }
    }

    public List<Integer> deleteSubject(String subject) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.deleteSubject(subject);
            return list;
        }
    }

    public List<Integer> deleteSubject(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.deleteSubject(subject);
            return list;
        }
    }

    public Integer deleteSchemaVersion(String subject, String version) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Integer n = this.delegate.deleteSchemaVersion(subject, version);
            return n;
        }
    }

    public Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version) throws IOException, RestClientException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Integer n = this.delegate.deleteSchemaVersion(requestProperties, subject, version);
            return n;
        }
    }

    public void reset() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.reset();
        }
    }
}

