/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.protobuf;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import io.trino.decoder.protobuf.ProtobufErrorCode;
import io.trino.decoder.protobuf.ProtobufUtils;
import io.trino.plugin.kafka.encoder.RowEncoder;
import io.trino.plugin.kafka.encoder.RowEncoderFactory;
import io.trino.plugin.kafka.encoder.RowEncoderSpec;
import io.trino.plugin.kafka.encoder.protobuf.ProtobufRowEncoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;

public class ProtobufRowEncoderFactory
implements RowEncoderFactory {
    @Override
    public RowEncoder create(ConnectorSession session, RowEncoderSpec rowEncoderSpec) {
        Preconditions.checkArgument((boolean)rowEncoderSpec.dataSchema().isPresent(), (Object)"dataSchema for Protobuf format is not present");
        try {
            Descriptors.Descriptor descriptor = ProtobufUtils.getFileDescriptor((String)rowEncoderSpec.dataSchema().get()).findMessageTypeByName("schema");
            if (descriptor != null) {
                return new ProtobufRowEncoder(descriptor, session, rowEncoderSpec.columnHandles());
            }
        }
        catch (Descriptors.DescriptorValidationException descriptorValidationException) {
            throw new TrinoException((ErrorCodeSupplier)ProtobufErrorCode.INVALID_PROTO_FILE, "Unable to parse protobuf schema", (Throwable)descriptorValidationException);
        }
        throw new TrinoException((ErrorCodeSupplier)ProtobufErrorCode.MESSAGE_NOT_FOUND, String.format("Message %s not found", "schema"));
    }
}

