/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json.format;

import io.trino.plugin.kafka.encoder.json.format.JsonDateTimeFormatter;
import io.trino.plugin.kafka.encoder.json.format.util.TimeConversions;
import io.trino.spi.type.DateType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class ISO8601DateTimeFormatter
implements JsonDateTimeFormatter {
    public static boolean isSupportedType(Type type) {
        return type.equals(DateType.DATE) || type.equals(TimeType.TIME_MILLIS) || type.equals(TimeWithTimeZoneType.TIME_TZ_MILLIS) || type.equals(TimestampType.TIMESTAMP_MILLIS) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
    }

    @Override
    public String formatDate(SqlDate value) {
        return LocalDate.ofEpochDay(value.getDays()).toString();
    }

    @Override
    public String formatTime(SqlTime value, int precision) {
        return LocalTime.ofNanoOfDay(TimeConversions.getNanosOfDay(TimeConversions.scalePicosToNanos(value.getPicos()))).toString();
    }

    @Override
    public String formatTimeWithZone(SqlTimeWithTimeZone value) {
        int offsetMinutes = value.getOffsetMinutes();
        return DateTimeFormatter.ISO_OFFSET_TIME.format(LocalTime.ofNanoOfDay(TimeConversions.scalePicosToNanos(value.getPicos())).atOffset(ZoneOffset.ofHoursMinutes(offsetMinutes / 60, offsetMinutes % 60)));
    }

    @Override
    public String formatTimestamp(SqlTimestamp value) {
        long epochMicros = value.getEpochMicros();
        long picosOfMicros = value.getPicosOfMicros();
        long epochSecond = TimeConversions.scaleEpochMicrosToSeconds(epochMicros);
        int nanoFraction = TimeConversions.getMicrosOfSecond(epochMicros) * 1000 + (int)TimeConversions.scalePicosToNanos(picosOfMicros);
        Instant instant = Instant.ofEpochSecond(epochSecond, nanoFraction);
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC).toString();
    }

    @Override
    public String formatTimestampWithZone(SqlTimestampWithTimeZone value) {
        long epochMillis = value.getEpochMillis();
        int picosOfMilli = value.getPicosOfMilli();
        long epochSecond = TimeConversions.scaleEpochMillisToSeconds(epochMillis);
        int nanoFraction = TimeConversions.getMillisOfSecond(epochMillis) * 1000000 + (int)TimeConversions.scalePicosToMillis(picosOfMilli);
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(Instant.ofEpochSecond(epochSecond, nanoFraction).atZone(value.getTimeZoneKey().getZoneId()));
    }
}

