/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.kafka.KafkaTopicFieldDescription;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class KafkaTopicFieldGroup {
    private final String dataFormat;
    private final Optional<String> dataSchema;
    private final Optional<String> subject;
    private final List<KafkaTopicFieldDescription> fields;

    @JsonCreator
    public KafkaTopicFieldGroup(@JsonProperty(value="dataFormat") String dataFormat, @JsonProperty(value="dataSchema") Optional<String> dataSchema, @JsonProperty(value="subject") Optional<String> subject, @JsonProperty(value="fields") List<KafkaTopicFieldDescription> fields) {
        this.dataFormat = Objects.requireNonNull(dataFormat, "dataFormat is null");
        this.dataSchema = Objects.requireNonNull(dataSchema, "dataSchema is null");
        this.subject = Objects.requireNonNull(subject, "subject is null");
        this.fields = ImmutableList.copyOf((Collection)Objects.requireNonNull(fields, "fields is null"));
    }

    @JsonProperty
    public String getDataFormat() {
        return this.dataFormat;
    }

    @JsonProperty
    public List<KafkaTopicFieldDescription> getFields() {
        return this.fields;
    }

    @JsonProperty
    public Optional<String> getDataSchema() {
        return this.dataSchema;
    }

    @JsonProperty
    public Optional<String> getSubject() {
        return this.subject;
    }

    public int hashCode() {
        return Objects.hash(this.dataFormat, this.dataSchema, this.subject, this.fields);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KafkaTopicFieldGroup other = (KafkaTopicFieldGroup)obj;
        return Objects.equals(this.dataFormat, other.dataFormat) && Objects.equals(this.dataSchema, other.dataSchema) && Objects.equals(this.subject, other.subject) && Objects.equals(this.fields, other.fields);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dataFormat", (Object)this.dataFormat).add("dataSchema", this.dataSchema).add("subject", this.subject).add("fields", this.fields).toString();
    }
}

