/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.plugin.kafka.Range;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class KafkaSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(KafkaSplit.class);
    private final String topicName;
    private final String keyDataFormat;
    private final String messageDataFormat;
    private final Optional<String> keyDataSchemaContents;
    private final Optional<String> messageDataSchemaContents;
    private final int partitionId;
    private final Range messagesRange;
    private final HostAddress leader;

    @JsonCreator
    public KafkaSplit(@JsonProperty(value="topicName") String topicName, @JsonProperty(value="keyDataFormat") String keyDataFormat, @JsonProperty(value="messageDataFormat") String messageDataFormat, @JsonProperty(value="keyDataSchemaContents") Optional<String> keyDataSchemaContents, @JsonProperty(value="messageDataSchemaContents") Optional<String> messageDataSchemaContents, @JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="messagesRange") Range messagesRange, @JsonProperty(value="leader") HostAddress leader) {
        this.topicName = Objects.requireNonNull(topicName, "topicName is null");
        this.keyDataFormat = Objects.requireNonNull(keyDataFormat, "keyDataFormat is null");
        this.messageDataFormat = Objects.requireNonNull(messageDataFormat, "messageDataFormat is null");
        this.keyDataSchemaContents = Objects.requireNonNull(keyDataSchemaContents, "keyDataSchemaContents is null");
        this.messageDataSchemaContents = Objects.requireNonNull(messageDataSchemaContents, "messageDataSchemaContents is null");
        this.partitionId = partitionId;
        this.messagesRange = Objects.requireNonNull(messagesRange, "messagesRange is null");
        this.leader = Objects.requireNonNull(leader, "leader is null");
    }

    @JsonProperty
    public String getTopicName() {
        return this.topicName;
    }

    @JsonProperty
    public String getKeyDataFormat() {
        return this.keyDataFormat;
    }

    @JsonProperty
    public String getMessageDataFormat() {
        return this.messageDataFormat;
    }

    @JsonProperty
    public Optional<String> getKeyDataSchemaContents() {
        return this.keyDataSchemaContents;
    }

    @JsonProperty
    public Optional<String> getMessageDataSchemaContents() {
        return this.messageDataSchemaContents;
    }

    @JsonProperty
    public int getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty
    public Range getMessagesRange() {
        return this.messagesRange;
    }

    @JsonProperty
    public HostAddress getLeader() {
        return this.leader;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of((Object)this.leader);
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.topicName) + SizeOf.estimatedSizeOf((String)this.keyDataFormat) + SizeOf.estimatedSizeOf((String)this.messageDataFormat) + SizeOf.sizeOf(this.keyDataSchemaContents, SizeOf::estimatedSizeOf) + SizeOf.sizeOf(this.messageDataSchemaContents, SizeOf::estimatedSizeOf) + this.messagesRange.getRetainedSizeInBytes() + this.leader.getRetainedSizeInBytes();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topicName", (Object)this.topicName).add("keyDataFormat", (Object)this.keyDataFormat).add("messageDataFormat", (Object)this.messageDataFormat).add("keyDataSchemaContents", this.keyDataSchemaContents).add("messageDataSchemaContents", this.messageDataSchemaContents).add("partitionId", this.partitionId).add("messagesRange", (Object)this.messagesRange).add("leader", (Object)this.leader).toString();
    }
}

