/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.kafka.KafkaErrorCode;
import io.trino.plugin.kafka.KafkaPageSink;
import io.trino.plugin.kafka.KafkaProducerFactory;
import io.trino.plugin.kafka.KafkaTableHandle;
import io.trino.plugin.kafka.encoder.DispatchingRowEncoderFactory;
import io.trino.plugin.kafka.encoder.EncoderColumnHandle;
import io.trino.plugin.kafka.encoder.KafkaFieldType;
import io.trino.plugin.kafka.encoder.RowEncoder;
import io.trino.plugin.kafka.encoder.RowEncoderSpec;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class KafkaPageSinkProvider
implements ConnectorPageSinkProvider {
    private final DispatchingRowEncoderFactory encoderFactory;
    private final KafkaProducerFactory producerFactory;

    @Inject
    public KafkaPageSinkProvider(DispatchingRowEncoderFactory encoderFactory, KafkaProducerFactory producerFactory) {
        this.encoderFactory = Objects.requireNonNull(encoderFactory, "encoderFactory is null");
        this.producerFactory = Objects.requireNonNull(producerFactory, "producerFactory is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        throw new UnsupportedOperationException("Table creation is not supported by the kafka connector");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        KafkaTableHandle handle = (KafkaTableHandle)tableHandle;
        ImmutableList.Builder keyColumns = ImmutableList.builder();
        ImmutableList.Builder messageColumns = ImmutableList.builder();
        handle.getColumns().forEach(col -> {
            if (col.isInternal()) {
                throw new IllegalArgumentException(String.format("unexpected internal column '%s'", col.getName()));
            }
            if (col.isKeyCodec()) {
                keyColumns.add(col);
            } else {
                messageColumns.add(col);
            }
        });
        RowEncoder keyEncoder = this.encoderFactory.create(session, KafkaPageSinkProvider.toRowEncoderSpec(handle, (List<EncoderColumnHandle>)keyColumns.build(), KafkaFieldType.KEY));
        RowEncoder messageEncoder = this.encoderFactory.create(session, KafkaPageSinkProvider.toRowEncoderSpec(handle, (List<EncoderColumnHandle>)messageColumns.build(), KafkaFieldType.MESSAGE));
        return new KafkaPageSink(handle.getTopicName(), handle.getColumns(), keyEncoder, messageEncoder, this.producerFactory, session);
    }

    private static RowEncoderSpec toRowEncoderSpec(KafkaTableHandle handle, List<EncoderColumnHandle> columns, KafkaFieldType kafkaFieldType) {
        return switch (kafkaFieldType) {
            default -> throw new IncompatibleClassChangeError();
            case KafkaFieldType.KEY -> new RowEncoderSpec(handle.getKeyDataFormat(), KafkaPageSinkProvider.getDataSchema(handle.getKeyDataSchemaLocation()), columns, handle.getTopicName(), kafkaFieldType);
            case KafkaFieldType.MESSAGE -> new RowEncoderSpec(handle.getMessageDataFormat(), KafkaPageSinkProvider.getDataSchema(handle.getMessageDataSchemaLocation()), columns, handle.getTopicName(), kafkaFieldType);
        };
    }

    private static Optional<String> getDataSchema(Optional<String> dataSchemaLocation) {
        return dataSchemaLocation.map(location -> {
            try {
                return Files.readString(Paths.get(location, new String[0]));
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_SCHEMA_ERROR, String.format("Unable to read data schema at '%s'", location), (Throwable)e);
            }
        });
    }
}

