/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.kafka.KafkaColumnHandle;
import io.trino.plugin.kafka.KafkaErrorCode;
import io.trino.plugin.kafka.KafkaProducerFactory;
import io.trino.plugin.kafka.encoder.RowEncoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class KafkaPageSink
implements ConnectorPageSink {
    private final String topicName;
    private final List<KafkaColumnHandle> columns;
    private final RowEncoder keyEncoder;
    private final RowEncoder messageEncoder;
    private final KafkaProducer<byte[], byte[]> producer;
    private final ProducerCallback producerCallback;
    private long expectedWrittenBytes;

    public KafkaPageSink(String topicName, List<KafkaColumnHandle> columns, RowEncoder keyEncoder, RowEncoder messageEncoder, KafkaProducerFactory producerFactory, ConnectorSession session) {
        this.topicName = Objects.requireNonNull(topicName, "topicName is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.keyEncoder = Objects.requireNonNull(keyEncoder, "keyEncoder is null");
        this.messageEncoder = Objects.requireNonNull(messageEncoder, "messageEncoder is null");
        Objects.requireNonNull(producerFactory, "producerFactory is null");
        Objects.requireNonNull(session, "session is null");
        this.producer = producerFactory.create(session);
        this.producerCallback = new ProducerCallback();
        this.expectedWrittenBytes = 0L;
    }

    public long getCompletedBytes() {
        return this.producerCallback.getWrittenBytes();
    }

    public CompletableFuture<?> appendPage(Page page) {
        for (int position = 0; position < page.getPositionCount(); ++position) {
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                if (this.columns.get(channel).isKeyCodec()) {
                    this.keyEncoder.appendColumnValue(page.getBlock(channel), position);
                    continue;
                }
                this.messageEncoder.appendColumnValue(page.getBlock(channel), position);
            }
            byte[] keyBytes = this.keyEncoder.toByteArray();
            byte[] messageBytes = this.messageEncoder.toByteArray();
            this.expectedWrittenBytes += (long)(keyBytes.length + messageBytes.length);
            this.producer.send(new ProducerRecord(this.topicName, (Object)keyBytes, (Object)messageBytes), (Callback)this.producerCallback);
        }
        return NOT_BLOCKED;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        this.producer.flush();
        this.producer.close();
        try {
            this.keyEncoder.close();
            this.messageEncoder.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close row encoders", e);
        }
        Preconditions.checkArgument((this.producerCallback.getWrittenBytes() == this.expectedWrittenBytes ? 1 : 0) != 0, (Object)String.format("Actual written bytes: '%s' not equal to expected written bytes: '%s'", this.producerCallback.getWrittenBytes(), this.expectedWrittenBytes));
        if (this.producerCallback.getErrorCount() > 0L) {
            throw new TrinoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_PRODUCER_ERROR, String.format("%d producer record(s) failed to send", this.producerCallback.getErrorCount()));
        }
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
        this.producer.close();
    }

    private static class ProducerCallback
    implements Callback {
        private long errorCount = 0L;
        private long writtenBytes = 0L;

        public void onCompletion(RecordMetadata recordMetadata, Exception e) {
            if (e != null) {
                ++this.errorCount;
            } else {
                this.writtenBytes += (long)(recordMetadata.serializedValueSize() + recordMetadata.serializedKeySize());
            }
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        public long getWrittenBytes() {
            return this.writtenBytes;
        }
    }
}

