/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonCodecBinder;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorMetadata;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorRecordSetProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitManager;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.kafka.KafkaConfig;
import io.trino.plugin.kafka.KafkaConnector;
import io.trino.plugin.kafka.KafkaFilterManager;
import io.trino.plugin.kafka.KafkaInternalFieldManager;
import io.trino.plugin.kafka.KafkaMetadata;
import io.trino.plugin.kafka.KafkaPageSinkProvider;
import io.trino.plugin.kafka.KafkaRecordSetProvider;
import io.trino.plugin.kafka.KafkaSessionProperties;
import io.trino.plugin.kafka.KafkaSplitManager;
import io.trino.plugin.kafka.KafkaTopicDescription;
import io.trino.plugin.kafka.schema.confluent.ConfluentModule;
import io.trino.plugin.kafka.schema.file.FileTableDescriptionSupplierModule;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.type.TypeManager;
import java.util.Objects;

public class KafkaConnectorModule
extends AbstractConfigurationAwareModule {
    private final TypeManager typeManager;

    public KafkaConnectorModule(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public void setup(Binder binder) {
        binder.bind(ConnectorMetadata.class).annotatedWith(ForClassLoaderSafe.class).to(KafkaMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorMetadata.class).to(ClassLoaderSafeConnectorMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).annotatedWith(ForClassLoaderSafe.class).to(KafkaSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(ClassLoaderSafeConnectorSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorRecordSetProvider.class).annotatedWith(ForClassLoaderSafe.class).to(KafkaRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorRecordSetProvider.class).to(ClassLoaderSafeConnectorRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).annotatedWith(ForClassLoaderSafe.class).to(KafkaPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).to(ClassLoaderSafeConnectorPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(KafkaConnector.class).in(Scopes.SINGLETON);
        binder.bind(KafkaInternalFieldManager.class).in(Scopes.SINGLETON);
        binder.bind(KafkaSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(KafkaFilterManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(KafkaConfig.class);
        this.bindTopicSchemaProviderModule("file", (Module)new FileTableDescriptionSupplierModule());
        this.bindTopicSchemaProviderModule("confluent", (Module)new ConfluentModule(this.typeManager));
        Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class).addBinding().to(KafkaSessionProperties.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(KafkaTopicDescription.class);
    }

    public void bindTopicSchemaProviderModule(String name, Module module) {
        this.install(ConditionalModule.conditionalModule(KafkaConfig.class, kafkaConfig -> name.equalsIgnoreCase(kafkaConfig.getTableDescriptionSupplier()), (Module)module));
    }
}

