/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.plugin.kafka.encoder.EncoderColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Objects;

public final class KafkaColumnHandle
implements EncoderColumnHandle,
DecoderColumnHandle {
    private final String name;
    private final Type type;
    private final String mapping;
    private final String dataFormat;
    private final String formatHint;
    private final boolean keyCodec;
    private final boolean hidden;
    private final boolean internal;

    @JsonCreator
    public KafkaColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="mapping") String mapping, @JsonProperty(value="dataFormat") String dataFormat, @JsonProperty(value="formatHint") String formatHint, @JsonProperty(value="keyCodec") boolean keyCodec, @JsonProperty(value="hidden") boolean hidden, @JsonProperty(value="internal") boolean internal) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.mapping = mapping;
        this.dataFormat = dataFormat;
        this.formatHint = formatHint;
        this.keyCodec = keyCodec;
        this.hidden = hidden;
        this.internal = internal;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getMapping() {
        return this.mapping;
    }

    @Override
    @JsonProperty
    public String getDataFormat() {
        return this.dataFormat;
    }

    @Override
    @JsonProperty
    public String getFormatHint() {
        return this.formatHint;
    }

    @JsonProperty
    public boolean isKeyCodec() {
        return this.keyCodec;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    @JsonProperty
    public boolean isInternal() {
        return this.internal;
    }

    ColumnMetadata getColumnMetadata() {
        return ColumnMetadata.builder().setName(this.name).setType(this.type).setHidden(this.hidden).build();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.mapping, this.dataFormat, this.formatHint, this.keyCodec, this.hidden, this.internal);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KafkaColumnHandle other = (KafkaColumnHandle)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.mapping, other.mapping) && Objects.equals(this.dataFormat, other.dataFormat) && Objects.equals(this.formatHint, other.formatHint) && Objects.equals(this.keyCodec, other.keyCodec) && Objects.equals(this.hidden, other.hidden) && Objects.equals(this.internal, other.internal);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("mapping", (Object)this.mapping).add("dataFormat", (Object)this.dataFormat).add("formatHint", (Object)this.formatHint).add("keyCodec", this.keyCodec).add("hidden", this.hidden).add("internal", this.internal).toString();
    }
}

