/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.inject.Inject;
import io.trino.plugin.kafka.KafkaConfig;
import io.trino.plugin.kafka.KafkaProducerFactory;
import io.trino.plugin.kafka.utils.PropertiesUtils;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSession;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public class DefaultKafkaProducerFactory
implements KafkaProducerFactory {
    private final Set<HostAddress> nodes;
    private final Map<String, String> configurationProperties;

    @Inject
    public DefaultKafkaProducerFactory(KafkaConfig kafkaConfig) throws Exception {
        this.nodes = kafkaConfig.getNodes();
        this.configurationProperties = PropertiesUtils.readProperties(kafkaConfig.getResourceConfigFiles());
    }

    @Override
    public Properties configure(ConnectorSession session) {
        Properties properties = new Properties();
        properties.putAll(this.configurationProperties);
        properties.setProperty("bootstrap.servers", this.nodes.stream().map(HostAddress::toString).collect(Collectors.joining(",")));
        properties.setProperty("key.serializer", ByteArraySerializer.class.getName());
        properties.setProperty("value.serializer", ByteArraySerializer.class.getName());
        properties.setProperty("acks", "all");
        properties.setProperty("linger.ms", Long.toString(5L));
        return properties;
    }
}

