/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.split;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hudi.HudiErrorCode;
import io.trino.plugin.hudi.HudiFileStatus;
import io.trino.plugin.hudi.HudiSplit;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.plugin.hudi.split.HudiSplitWeightProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.List;
import java.util.Objects;

public class HudiSplitFactory {
    private static final double SPLIT_SLOP = 1.1;
    private final HudiTableHandle hudiTableHandle;
    private final HudiSplitWeightProvider hudiSplitWeightProvider;

    public HudiSplitFactory(HudiTableHandle hudiTableHandle, HudiSplitWeightProvider hudiSplitWeightProvider) {
        this.hudiTableHandle = Objects.requireNonNull(hudiTableHandle, "hudiTableHandle is null");
        this.hudiSplitWeightProvider = Objects.requireNonNull(hudiSplitWeightProvider, "hudiSplitWeightProvider is null");
    }

    public List<HudiSplit> createSplits(List<HivePartitionKey> partitionKeys, HudiFileStatus fileStatus) {
        if (fileStatus.isDirectory()) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_FILESYSTEM_ERROR, String.format("Not a valid location: %s", fileStatus.location()));
        }
        long fileSize = fileStatus.length();
        if (fileSize == 0L) {
            return ImmutableList.of((Object)new HudiSplit(fileStatus.location().toString(), 0L, fileSize, fileSize, fileStatus.modificationTime(), this.hudiTableHandle.getRegularPredicates(), partitionKeys, this.hudiSplitWeightProvider.calculateSplitWeight(fileSize)));
        }
        ImmutableList.Builder splits = ImmutableList.builder();
        long splitSize = fileStatus.blockSize();
        long bytesRemaining = fileSize;
        while ((double)bytesRemaining / (double)splitSize > 1.1) {
            splits.add((Object)new HudiSplit(fileStatus.location().toString(), fileSize - bytesRemaining, splitSize, fileSize, fileStatus.modificationTime(), this.hudiTableHandle.getRegularPredicates(), partitionKeys, this.hudiSplitWeightProvider.calculateSplitWeight(splitSize)));
            bytesRemaining -= splitSize;
        }
        if (bytesRemaining > 0L) {
            splits.add((Object)new HudiSplit(fileStatus.location().toString(), fileSize - bytesRemaining, bytesRemaining, fileSize, fileStatus.modificationTime(), this.hudiTableHandle.getRegularPredicates(), partitionKeys, this.hudiSplitWeightProvider.calculateSplitWeight(bytesRemaining)));
        }
        return splits.build();
    }
}

