/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HudiReplaceCommitMetadata {
    private Map<String, List<String>> partitionToReplaceFileIds = ImmutableMap.of();
    private Boolean compacted = false;

    public Map<String, List<String>> getPartitionToReplaceFileIds() {
        return this.partitionToReplaceFileIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HudiReplaceCommitMetadata that = (HudiReplaceCommitMetadata)o;
        return this.compacted.equals(that.compacted);
    }

    public int hashCode() {
        return this.compacted.hashCode();
    }

    public static <T> T fromBytes(byte[] bytes, ObjectMapper objectMapper, Class<T> clazz) throws IOException {
        try {
            String jsonStr = new String(bytes, StandardCharsets.UTF_8);
            if (jsonStr == null || jsonStr.isEmpty()) {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (T)objectMapper.readValue(jsonStr, clazz);
        }
        catch (Exception e) {
            throw new IOException("unable to read commit metadata", e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionToReplaceFileIds", this.partitionToReplaceFileIds).add("compacted", (Object)this.compacted).toString();
    }
}

