/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import io.trino.plugin.hudi.TableType;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HudiTableName {
    private static final Pattern TABLE_PATTERN = Pattern.compile("(?<table>[^$@]+)(?:\\$(?<type>[^@]+))?");
    private final String tableName;
    private final TableType tableType;

    public HudiTableName(String tableName, TableType tableType) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
    }

    public String getTableName() {
        return this.tableName;
    }

    public TableType getTableType() {
        return this.tableType;
    }

    public String getTableNameWithType() {
        return this.tableName + "$" + this.tableType.name().toLowerCase(Locale.ENGLISH);
    }

    public String toString() {
        return this.getTableNameWithType();
    }

    public static HudiTableName from(String name) {
        Matcher match = TABLE_PATTERN.matcher(name);
        if (!match.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Hudi table name: " + name);
        }
        String table = match.group("table");
        String typeString = match.group("type");
        TableType type = TableType.DATA;
        if (typeString != null) {
            try {
                type = TableType.valueOf(typeString.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Invalid Hudi table name (unknown type '%s'): %s", typeString, name));
            }
        }
        return new HudiTableName(table, type);
    }
}

