/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hudi.HudiConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class HudiSessionProperties
implements SessionPropertiesProvider {
    private static final String COLUMNS_TO_HIDE = "columns_to_hide";
    private static final String METADATA_ENABLED = "metadata_enabled";
    private static final String USE_PARQUET_COLUMN_NAMES = "use_parquet_column_names";
    private static final String PARQUET_OPTIMIZED_READER_ENABLED = "parquet_optimized_reader_enabled";
    private static final String PARQUET_OPTIMIZED_NESTED_READER_ENABLED = "parquet_optimized_nested_reader_enabled";
    private static final String SIZE_BASED_SPLIT_WEIGHTS_ENABLED = "size_based_split_weights_enabled";
    private static final String STANDARD_SPLIT_WEIGHT_SIZE = "standard_split_weight_size";
    private static final String MINIMUM_ASSIGNED_SPLIT_WEIGHT = "minimum_assigned_split_weight";
    private static final String MAX_SPLITS_PER_SECOND = "max_splits_per_second";
    private static final String MAX_OUTSTANDING_SPLITS = "max_outstanding_splits";
    private static final String SPLIT_GENERATOR_PARALLELISM = "split_generator_parallelism";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public HudiSessionProperties(HudiConfig hudiConfig, ParquetReaderConfig parquetReaderConfig) {
        this.sessionProperties = ImmutableList.of((Object)new PropertyMetadata(COLUMNS_TO_HIDE, "List of column names that will be hidden", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, hudiConfig.getColumnsToHide(), false, value -> (List)((Collection)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)PropertyMetadata.booleanProperty((String)METADATA_ENABLED, (String)"For Hudi tables prefer to fetch the list of files from its metadata", (Boolean)hudiConfig.isMetadataEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)USE_PARQUET_COLUMN_NAMES, (String)"Access parquet columns using names from the file. If disabled, then columns are accessed using index.", (Boolean)hudiConfig.getUseParquetColumnNames(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_OPTIMIZED_READER_ENABLED, (String)"Use optimized Parquet reader", (Boolean)parquetReaderConfig.isOptimizedReaderEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_OPTIMIZED_NESTED_READER_ENABLED, (String)"Use optimized Parquet reader for nested columns", (Boolean)parquetReaderConfig.isOptimizedNestedReaderEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)SIZE_BASED_SPLIT_WEIGHTS_ENABLED, (String)String.format("If enabled, size-based splitting ensures that each batch of splits has enough data to process as defined by %s", STANDARD_SPLIT_WEIGHT_SIZE), (Boolean)hudiConfig.isSizeBasedSplitWeightsEnabled(), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)STANDARD_SPLIT_WEIGHT_SIZE, (String)"The split size corresponding to the standard weight (1.0) when size-based split weights are enabled", (DataSize)hudiConfig.getStandardSplitWeightSize(), (boolean)false), (Object)PropertyMetadata.doubleProperty((String)MINIMUM_ASSIGNED_SPLIT_WEIGHT, (String)"Minimum assigned split weight when size-based split weights are enabled", (Double)hudiConfig.getMinimumAssignedSplitWeight(), value -> {
            if (!Double.isFinite(value) || value <= 0.0 || value > 1.0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be > 0 and <= 1.0: %s", MINIMUM_ASSIGNED_SPLIT_WEIGHT, value));
            }
        }, (boolean)false), (Object)PropertyMetadata.integerProperty((String)MAX_SPLITS_PER_SECOND, (String)"Rate at which splits are enqueued for processing. The queue will throttle if this rate limit is breached.", (Integer)hudiConfig.getMaxSplitsPerSecond(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)MAX_OUTSTANDING_SPLITS, (String)"Maximum outstanding splits in a batch enqueued for processing", (Integer)hudiConfig.getMaxOutstandingSplits(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)SPLIT_GENERATOR_PARALLELISM, (String)"Number of threads to generate splits from partitions", (Integer)hudiConfig.getSplitGeneratorParallelism(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static List<String> getColumnsToHide(ConnectorSession session) {
        return (List)session.getProperty(COLUMNS_TO_HIDE, List.class);
    }

    public static boolean isHudiMetadataEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(METADATA_ENABLED, Boolean.class);
    }

    public static boolean shouldUseParquetColumnNames(ConnectorSession session) {
        return (Boolean)session.getProperty(USE_PARQUET_COLUMN_NAMES, Boolean.class);
    }

    public static boolean isParquetOptimizedReaderEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_OPTIMIZED_READER_ENABLED, Boolean.class);
    }

    public static boolean isParquetOptimizedNestedReaderEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_OPTIMIZED_NESTED_READER_ENABLED, Boolean.class);
    }

    public static boolean isSizeBasedSplitWeightsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(SIZE_BASED_SPLIT_WEIGHTS_ENABLED, Boolean.class);
    }

    public static DataSize getStandardSplitWeightSize(ConnectorSession session) {
        return (DataSize)session.getProperty(STANDARD_SPLIT_WEIGHT_SIZE, DataSize.class);
    }

    public static double getMinimumAssignedSplitWeight(ConnectorSession session) {
        return (Double)session.getProperty(MINIMUM_ASSIGNED_SPLIT_WEIGHT, Double.class);
    }

    public static int getMaxSplitsPerSecond(ConnectorSession session) {
        return (Integer)session.getProperty(MAX_SPLITS_PER_SECOND, Integer.class);
    }

    public static int getMaxOutstandingSplits(ConnectorSession session) {
        return (Integer)session.getProperty(MAX_OUTSTANDING_SPLITS, Integer.class);
    }

    public static int getSplitGeneratorParallelism(ConnectorSession session) {
        return (Integer)session.getProperty(SPLIT_GENERATOR_PARALLELISM, Integer.class);
    }
}

