/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.HashMap;
import java.util.Optional;

public class HudiPredicates {
    private final TupleDomain<HiveColumnHandle> partitionColumnPredicates;
    private final TupleDomain<HiveColumnHandle> regularColumnPredicates;

    public static HudiPredicates from(TupleDomain<ColumnHandle> predicate) {
        HashMap partitionColumnPredicates = new HashMap();
        HashMap regularColumnPredicates = new HashMap();
        Optional domains = predicate.getDomains();
        domains.ifPresent(columnHandleDomainMap -> columnHandleDomainMap.forEach((key, value) -> {
            HiveColumnHandle columnHandle = (HiveColumnHandle)key;
            if (columnHandle.isPartitionKey()) {
                partitionColumnPredicates.put(columnHandle, value);
            } else {
                regularColumnPredicates.put(columnHandle, value);
            }
        }));
        return new HudiPredicates((TupleDomain<HiveColumnHandle>)TupleDomain.withColumnDomains(partitionColumnPredicates), (TupleDomain<HiveColumnHandle>)TupleDomain.withColumnDomains(regularColumnPredicates));
    }

    private HudiPredicates(TupleDomain<HiveColumnHandle> partitionColumnPredicates, TupleDomain<HiveColumnHandle> regularColumnPredicates) {
        this.partitionColumnPredicates = partitionColumnPredicates;
        this.regularColumnPredicates = regularColumnPredicates;
    }

    public TupleDomain<HiveColumnHandle> getPartitionColumnPredicates() {
        return this.partitionColumnPredicates;
    }

    public TupleDomain<HiveColumnHandle> getRegularColumnPredicates() {
        return this.regularColumnPredicates;
    }
}

