/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class HudiPartitionManager {
    private final TypeManager typeManager;

    @Inject
    public HudiPartitionManager(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public List<String> getEffectivePartitions(HudiTableHandle tableHandle, HiveMetastore metastore) {
        Table table = (Table)metastore.getTable(tableHandle.getSchemaName(), tableHandle.getTableName()).orElseThrow(() -> new TableNotFoundException(tableHandle.getSchemaTableName()));
        List partitionColumns = table.getPartitionColumns();
        if (partitionColumns.isEmpty()) {
            return ImmutableList.of((Object)"");
        }
        List partitionColumnHandles = HiveUtil.getPartitionKeyColumnHandles((Table)table, (TypeManager)this.typeManager);
        return (List)metastore.getPartitionNamesByFilter(tableHandle.getSchemaName(), tableHandle.getTableName(), partitionColumns.stream().map(Column::getName).collect(Collectors.toList()), MetastoreUtil.computePartitionKeyFilter((List)partitionColumnHandles, tableHandle.getPartitionPredicates())).orElseThrow(() -> new TableNotFoundException(tableHandle.getSchemaTableName()));
    }
}

