/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.base.Throwables;
import io.trino.plugin.base.Versions;
import io.trino.plugin.hudi.InternalHudiConnectorFactory;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;

public class HudiConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "hudi";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        ClassLoader classLoader = context.duplicatePluginClassLoader();
        try {
            return (Connector)classLoader.loadClass(InternalHudiConnectorFactory.class.getName()).getMethod("createConnector", String.class, Map.class, ConnectorContext.class, Optional.class, Optional.class).invoke(null, catalogName, config, context, Optional.empty(), Optional.empty());
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            Throwables.throwIfUnchecked((Throwable)targetException);
            throw new RuntimeException(targetException);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

