/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.RemoteTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

public class MongoTableHandle
implements ConnectorTableHandle {
    private final SchemaTableName schemaTableName;
    private final RemoteTableName remoteTableName;
    private final Optional<String> filter;
    private final TupleDomain<ColumnHandle> constraint;
    private final Set<MongoColumnHandle> projectedColumns;
    private final OptionalInt limit;

    public MongoTableHandle(SchemaTableName schemaTableName, RemoteTableName remoteTableName, Optional<String> filter) {
        this(schemaTableName, remoteTableName, filter, (TupleDomain<ColumnHandle>)TupleDomain.all(), (Set<MongoColumnHandle>)ImmutableSet.of(), OptionalInt.empty());
    }

    @JsonCreator
    public MongoTableHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="remoteTableName") RemoteTableName remoteTableName, @JsonProperty(value="filter") Optional<String> filter, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="projectedColumns") Set<MongoColumnHandle> projectedColumns, @JsonProperty(value="limit") OptionalInt limit) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.remoteTableName = Objects.requireNonNull(remoteTableName, "remoteTableName is null");
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.projectedColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(projectedColumns, "projectedColumns is null"));
        this.limit = Objects.requireNonNull(limit, "limit is null");
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public RemoteTableName getRemoteTableName() {
        return this.remoteTableName;
    }

    @JsonProperty
    public Optional<String> getFilter() {
        return this.filter;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public Set<MongoColumnHandle> getProjectedColumns() {
        return this.projectedColumns;
    }

    @JsonProperty
    public OptionalInt getLimit() {
        return this.limit;
    }

    public MongoTableHandle withProjectedColumns(Set<MongoColumnHandle> projectedColumns) {
        return new MongoTableHandle(this.schemaTableName, this.remoteTableName, this.filter, this.constraint, projectedColumns, this.limit);
    }

    public int hashCode() {
        return Objects.hash(this.schemaTableName, this.filter, this.constraint, this.projectedColumns, this.limit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MongoTableHandle other = (MongoTableHandle)obj;
        return Objects.equals(this.schemaTableName, other.schemaTableName) && Objects.equals(this.remoteTableName, other.remoteTableName) && Objects.equals(this.filter, other.filter) && Objects.equals(this.constraint, other.constraint) && Objects.equals(this.projectedColumns, other.projectedColumns) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaTableName", (Object)this.schemaTableName).add("remoteTableName", (Object)this.remoteTableName).add("filter", this.filter).add("constraint", this.constraint).add("projectedColumns", this.projectedColumns).add("limit", (Object)this.limit).toString();
    }
}

