/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.Versions;
import io.trino.plugin.mongodb.MongoClientModule;
import io.trino.plugin.mongodb.MongoConnector;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;

public class MongoConnectorFactory
implements ConnectorFactory {
    private final String name;

    public MongoConnectorFactory(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new MongoClientModule(), binder -> binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager())});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(MongoConnector.class);
    }
}

