/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.trino.plugin.mongodb.ReadPreferenceType;
import io.trino.plugin.mongodb.WriteConcernType;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;

@DefunctConfig(value={"mongodb.connection-per-host", "mongodb.socket-keep-alive", "mongodb.seeds", "mongodb.credentials"})
public class MongoClientConfig {
    private String schemaCollection = "_schema";
    private boolean caseInsensitiveNameMatching;
    private String connectionUrl;
    private int minConnectionsPerHost;
    private int connectionsPerHost = 100;
    private int maxWaitTime = 120000;
    private int connectionTimeout = 10000;
    private int socketTimeout;
    private int maxConnectionIdleTime;
    private boolean tlsEnabled;
    private int cursorBatchSize;
    private ReadPreferenceType readPreference = ReadPreferenceType.PRIMARY;
    private WriteConcernType writeConcern = WriteConcernType.ACKNOWLEDGED;
    private String requiredReplicaSetName;
    private String implicitRowFieldPrefix = "_pos";
    private boolean projectionPushDownEnabled = true;

    @NotNull
    public String getSchemaCollection() {
        return this.schemaCollection;
    }

    @Config(value="mongodb.schema-collection")
    public MongoClientConfig setSchemaCollection(String schemaCollection) {
        this.schemaCollection = schemaCollection;
        return this;
    }

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="mongodb.case-insensitive-name-matching")
    public MongoClientConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        return this;
    }

    @NotNull
    @Pattern(message="Invalid connection URL. Expected mongodb:// or mongodb+srv://", regexp="^mongodb(\\+srv)?://.*")
    public @NotNull @Pattern(message="Invalid connection URL. Expected mongodb:// or mongodb+srv://", regexp="^mongodb(\\+srv)?://.*") String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Config(value="mongodb.connection-url")
    @ConfigSecuritySensitive
    public MongoClientConfig setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMinConnectionsPerHost() {
        return this.minConnectionsPerHost;
    }

    @Config(value="mongodb.min-connections-per-host")
    public MongoClientConfig setMinConnectionsPerHost(int minConnectionsPerHost) {
        this.minConnectionsPerHost = minConnectionsPerHost;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    @Config(value="mongodb.connections-per-host")
    public MongoClientConfig setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    @Config(value="mongodb.max-wait-time")
    public MongoClientConfig setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Config(value="mongodb.connection-timeout")
    public MongoClientConfig setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Config(value="mongodb.socket-timeout")
    public MongoClientConfig setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @NotNull
    public ReadPreferenceType getReadPreference() {
        return this.readPreference;
    }

    @Config(value="mongodb.read-preference")
    public MongoClientConfig setReadPreference(ReadPreferenceType readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    @NotNull
    public WriteConcernType getWriteConcern() {
        return this.writeConcern;
    }

    @Config(value="mongodb.write-concern")
    public MongoClientConfig setWriteConcern(WriteConcernType writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    @Config(value="mongodb.required-replica-set")
    public MongoClientConfig setRequiredReplicaSetName(String requiredReplicaSetName) {
        this.requiredReplicaSetName = requiredReplicaSetName;
        return this;
    }

    public int getCursorBatchSize() {
        return this.cursorBatchSize;
    }

    @Config(value="mongodb.cursor-batch-size")
    public MongoClientConfig setCursorBatchSize(int cursorBatchSize) {
        this.cursorBatchSize = cursorBatchSize;
        return this;
    }

    @NotNull
    public String getImplicitRowFieldPrefix() {
        return this.implicitRowFieldPrefix;
    }

    @Config(value="mongodb.implicit-row-field-prefix")
    public MongoClientConfig setImplicitRowFieldPrefix(String implicitRowFieldPrefix) {
        this.implicitRowFieldPrefix = implicitRowFieldPrefix;
        return this;
    }

    public boolean getTlsEnabled() {
        return this.tlsEnabled;
    }

    @Config(value="mongodb.tls.enabled")
    @LegacyConfig(value={"mongodb.ssl.enabled"})
    public MongoClientConfig setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Config(value="mongodb.max-connection-idle-time")
    public MongoClientConfig setMaxConnectionIdleTime(int maxConnectionIdleTime) {
        this.maxConnectionIdleTime = maxConnectionIdleTime;
        return this;
    }

    public boolean isProjectionPushdownEnabled() {
        return this.projectionPushDownEnabled;
    }

    @Config(value="mongodb.projection-pushdown-enabled")
    @ConfigDescription(value="Read only required fields from a row type")
    public MongoClientConfig setProjectionPushdownEnabled(boolean projectionPushDownEnabled) {
        this.projectionPushDownEnabled = projectionPushDownEnabled;
        return this;
    }
}

